/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetUtilization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetUtilization> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(FleetUtilization.getter(FleetUtilization::fleetId)).setter(FleetUtilization.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVER_PROCESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveServerProcessCount").getter(FleetUtilization.getter(FleetUtilization::activeServerProcessCount)).setter(FleetUtilization.setter(Builder::activeServerProcessCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveServerProcessCount").build()}).build();
    private static final SdkField<Integer> ACTIVE_GAME_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveGameSessionCount").getter(FleetUtilization.getter(FleetUtilization::activeGameSessionCount)).setter(FleetUtilization.setter(Builder::activeGameSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveGameSessionCount").build()}).build();
    private static final SdkField<Integer> CURRENT_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentPlayerSessionCount").getter(FleetUtilization.getter(FleetUtilization::currentPlayerSessionCount)).setter(FleetUtilization.setter(Builder::currentPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPlayerSessionCount").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount").getter(FleetUtilization.getter(FleetUtilization::maximumPlayerSessionCount)).setter(FleetUtilization.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ACTIVE_SERVER_PROCESS_COUNT_FIELD, ACTIVE_GAME_SESSION_COUNT_FIELD, CURRENT_PLAYER_SESSION_COUNT_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final Integer activeServerProcessCount;
    private final Integer activeGameSessionCount;
    private final Integer currentPlayerSessionCount;
    private final Integer maximumPlayerSessionCount;

    private FleetUtilization(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.activeServerProcessCount = builder.activeServerProcessCount;
        this.activeGameSessionCount = builder.activeGameSessionCount;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Integer activeServerProcessCount() {
        return this.activeServerProcessCount;
    }

    public Integer activeGameSessionCount() {
        return this.activeGameSessionCount;
    }

    public Integer currentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServerProcessCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeGameSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetUtilization)) {
            return false;
        }
        FleetUtilization other = (FleetUtilization)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.activeServerProcessCount(), other.activeServerProcessCount()) && Objects.equals(this.activeGameSessionCount(), other.activeGameSessionCount()) && Objects.equals(this.currentPlayerSessionCount(), other.currentPlayerSessionCount()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount());
    }

    public String toString() {
        return ToString.builder((String)"FleetUtilization").add("FleetId", (Object)this.fleetId()).add("ActiveServerProcessCount", (Object)this.activeServerProcessCount()).add("ActiveGameSessionCount", (Object)this.activeGameSessionCount()).add("CurrentPlayerSessionCount", (Object)this.currentPlayerSessionCount()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "ActiveServerProcessCount": {
                return Optional.ofNullable(clazz.cast(this.activeServerProcessCount()));
            }
            case "ActiveGameSessionCount": {
                return Optional.ofNullable(clazz.cast(this.activeGameSessionCount()));
            }
            case "CurrentPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.currentPlayerSessionCount()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetUtilization, T> g) {
        return obj -> g.apply((FleetUtilization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private Integer activeServerProcessCount;
        private Integer activeGameSessionCount;
        private Integer currentPlayerSessionCount;
        private Integer maximumPlayerSessionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetUtilization model) {
            this.fleetId(model.fleetId);
            this.activeServerProcessCount(model.activeServerProcessCount);
            this.activeGameSessionCount(model.activeGameSessionCount);
            this.currentPlayerSessionCount(model.currentPlayerSessionCount);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getActiveServerProcessCount() {
            return this.activeServerProcessCount;
        }

        @Override
        public final Builder activeServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
            return this;
        }

        public final void setActiveServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
        }

        public final Integer getActiveGameSessionCount() {
            return this.activeGameSessionCount;
        }

        @Override
        public final Builder activeGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
            return this;
        }

        public final void setActiveGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return this.currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public FleetUtilization build() {
            return new FleetUtilization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetUtilization> {
        public Builder fleetId(String var1);

        public Builder activeServerProcessCount(Integer var1);

        public Builder activeGameSessionCount(Integer var1);

        public Builder currentPlayerSessionCount(Integer var1);

        public Builder maximumPlayerSessionCount(Integer var1);
    }
}

