/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchResponse;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.ConflictException;
import software.amazon.awssdk.services.gamelift.model.CreateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.CreateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.CreateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.CreateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.CreateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityExceededException;
import software.amazon.awssdk.services.gamelift.model.GameLiftException;
import software.amazon.awssdk.services.gamelift.model.GameSessionFullException;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse;
import software.amazon.awssdk.services.gamelift.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.gamelift.model.InternalServiceException;
import software.amazon.awssdk.services.gamelift.model.InvalidFleetStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidGameSessionStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidRequestException;
import software.amazon.awssdk.services.gamelift.model.LimitExceededException;
import software.amazon.awssdk.services.gamelift.model.ListAliasesRequest;
import software.amazon.awssdk.services.gamelift.model.ListAliasesResponse;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamelift.model.NotFoundException;
import software.amazon.awssdk.services.gamelift.model.OutOfCapacityException;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.TagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.TagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.TaggingFailedException;
import software.amazon.awssdk.services.gamelift.model.TerminalRoutingStrategyException;
import software.amazon.awssdk.services.gamelift.model.UnauthorizedException;
import software.amazon.awssdk.services.gamelift.model.UnsupportedRegionException;
import software.amazon.awssdk.services.gamelift.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.transform.AcceptMatchRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ClaimGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeregisterGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeEc2InstanceLimitsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetEventsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetUtilizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionDetailsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionQueuesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeScalingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetGameSessionLogUrlRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetInstanceAccessRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListGameServerGroupsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListGameServersRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListScriptsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RegisterGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RequestUploadCredentialsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ResolveAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ResumeGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.SearchGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchBackfillRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.SuspendGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ValidateMatchmakingRuleSetRequestMarshaller;

@SdkInternalApi
final class DefaultGameLiftClient
implements GameLiftClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGameLiftClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "gamelift";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptMatchResponse acceptMatch(AcceptMatchRequest acceptMatchRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptMatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptMatch");
            AcceptMatchResponse acceptMatchResponse = (AcceptMatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptMatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptMatchRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AcceptMatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptMatchResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, acceptMatchRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClaimGameServerResponse claimGameServer(ClaimGameServerRequest claimGameServerRequest) throws InvalidRequestException, NotFoundException, ConflictException, OutOfCapacityException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClaimGameServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClaimGameServer");
            ClaimGameServerResponse claimGameServerResponse = (ClaimGameServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClaimGameServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)claimGameServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ClaimGameServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return claimGameServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, claimGameServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws UnauthorizedException, InvalidRequestException, ConflictException, InternalServiceException, LimitExceededException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            CreateAliasResponse createAliasResponse = (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBuildResponse createBuild(CreateBuildRequest createBuildRequest) throws UnauthorizedException, InvalidRequestException, ConflictException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBuild");
            CreateBuildResponse createBuildResponse = (CreateBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBuild").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBuildRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBuildResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createBuildRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InternalServiceException, NotFoundException, ConflictException, LimitExceededException, InvalidRequestException, UnauthorizedException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFleet");
            CreateFleetResponse createFleetResponse = (CreateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFleetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFleetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createFleetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGameServerGroupResponse createGameServerGroup(CreateGameServerGroupRequest createGameServerGroupRequest) throws InvalidRequestException, ConflictException, UnauthorizedException, InternalServiceException, LimitExceededException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGameServerGroup");
            CreateGameServerGroupResponse createGameServerGroupResponse = (CreateGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGameSessionResponse createGameSession(CreateGameSessionRequest createGameSessionRequest) throws ConflictException, InternalServiceException, UnauthorizedException, InvalidFleetStatusException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, FleetCapacityExceededException, LimitExceededException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGameSession");
            CreateGameSessionResponse createGameSessionResponse = (CreateGameSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGameSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGameSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGameSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createGameSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGameSessionQueueResponse createGameSessionQueue(CreateGameSessionQueueRequest createGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, LimitExceededException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGameSessionQueue");
            CreateGameSessionQueueResponse createGameSessionQueueResponse = (CreateGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGameSessionQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameSessionQueueRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGameSessionQueueResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createGameSessionQueueRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMatchmakingConfigurationResponse createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest createMatchmakingConfigurationRequest) throws InvalidRequestException, LimitExceededException, NotFoundException, InternalServiceException, UnsupportedRegionException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMatchmakingConfiguration");
            CreateMatchmakingConfigurationResponse createMatchmakingConfigurationResponse = (CreateMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMatchmakingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMatchmakingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMatchmakingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createMatchmakingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMatchmakingRuleSetResponse createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest createMatchmakingRuleSetRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMatchmakingRuleSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMatchmakingRuleSet");
            CreateMatchmakingRuleSetResponse createMatchmakingRuleSetResponse = (CreateMatchmakingRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMatchmakingRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMatchmakingRuleSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateMatchmakingRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMatchmakingRuleSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createMatchmakingRuleSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlayerSessionResponse createPlayerSession(CreatePlayerSessionRequest createPlayerSessionRequest) throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePlayerSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePlayerSession");
            CreatePlayerSessionResponse createPlayerSessionResponse = (CreatePlayerSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlayerSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlayerSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreatePlayerSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPlayerSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createPlayerSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlayerSessionsResponse createPlayerSessions(CreatePlayerSessionsRequest createPlayerSessionsRequest) throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePlayerSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePlayerSessions");
            CreatePlayerSessionsResponse createPlayerSessionsResponse = (CreatePlayerSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlayerSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlayerSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreatePlayerSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPlayerSessionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createPlayerSessionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateScriptResponse createScript(CreateScriptRequest createScriptRequest) throws UnauthorizedException, InvalidRequestException, ConflictException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScriptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScript");
            CreateScriptResponse createScriptResponse = (CreateScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScript").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createScriptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createScriptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createScriptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcPeeringAuthorizationResponse createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest createVpcPeeringAuthorizationRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcPeeringAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVpcPeeringAuthorization");
            CreateVpcPeeringAuthorizationResponse createVpcPeeringAuthorizationResponse = (CreateVpcPeeringAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVpcPeeringAuthorization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcPeeringAuthorizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcPeeringAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVpcPeeringAuthorizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createVpcPeeringAuthorizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcPeeringConnectionResponse createVpcPeeringConnection(CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcPeeringConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVpcPeeringConnection");
            CreateVpcPeeringConnectionResponse createVpcPeeringConnectionResponse = (CreateVpcPeeringConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVpcPeeringConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcPeeringConnectionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcPeeringConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVpcPeeringConnectionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, createVpcPeeringConnectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws UnauthorizedException, NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlias");
            DeleteAliasResponse deleteAliasResponse = (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBuildResponse deleteBuild(DeleteBuildRequest deleteBuildRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, TaggingFailedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBuild");
            DeleteBuildResponse deleteBuildResponse = (DeleteBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBuild").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBuildRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBuildResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteBuildRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws NotFoundException, InternalServiceException, InvalidFleetStatusException, UnauthorizedException, InvalidRequestException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFleet");
            DeleteFleetResponse deleteFleetResponse = (DeleteFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFleetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFleetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteFleetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGameServerGroupResponse deleteGameServerGroup(DeleteGameServerGroupRequest deleteGameServerGroupRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGameServerGroup");
            DeleteGameServerGroupResponse deleteGameServerGroupResponse = (DeleteGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGameSessionQueueResponse deleteGameSessionQueue(DeleteGameSessionQueueRequest deleteGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGameSessionQueue");
            DeleteGameSessionQueueResponse deleteGameSessionQueueResponse = (DeleteGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGameSessionQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGameSessionQueueRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGameSessionQueueResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteGameSessionQueueRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMatchmakingConfigurationResponse deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest deleteMatchmakingConfigurationRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMatchmakingConfiguration");
            DeleteMatchmakingConfigurationResponse deleteMatchmakingConfigurationResponse = (DeleteMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMatchmakingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMatchmakingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMatchmakingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteMatchmakingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMatchmakingRuleSetResponse deleteMatchmakingRuleSet(DeleteMatchmakingRuleSetRequest deleteMatchmakingRuleSetRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, NotFoundException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMatchmakingRuleSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMatchmakingRuleSet");
            DeleteMatchmakingRuleSetResponse deleteMatchmakingRuleSetResponse = (DeleteMatchmakingRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMatchmakingRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMatchmakingRuleSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMatchmakingRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMatchmakingRuleSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteMatchmakingRuleSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScalingPolicyResponse deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScalingPolicy");
            DeleteScalingPolicyResponse deleteScalingPolicyResponse = (DeleteScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScalingPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScalingPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteScalingPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScriptResponse deleteScript(DeleteScriptRequest deleteScriptRequest) throws InvalidRequestException, UnauthorizedException, NotFoundException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScriptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScript");
            DeleteScriptResponse deleteScriptResponse = (DeleteScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScript").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScriptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScriptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteScriptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcPeeringAuthorizationResponse deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest deleteVpcPeeringAuthorizationRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcPeeringAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVpcPeeringAuthorization");
            DeleteVpcPeeringAuthorizationResponse deleteVpcPeeringAuthorizationResponse = (DeleteVpcPeeringAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVpcPeeringAuthorization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcPeeringAuthorizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcPeeringAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVpcPeeringAuthorizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteVpcPeeringAuthorizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcPeeringConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVpcPeeringConnection");
            DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnectionResponse = (DeleteVpcPeeringConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVpcPeeringConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcPeeringConnectionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcPeeringConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVpcPeeringConnectionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deleteVpcPeeringConnectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterGameServerResponse deregisterGameServer(DeregisterGameServerRequest deregisterGameServerRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterGameServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterGameServer");
            DeregisterGameServerResponse deregisterGameServerResponse = (DeregisterGameServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterGameServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterGameServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterGameServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterGameServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, deregisterGameServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAliasResponse describeAlias(DescribeAliasRequest describeAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlias");
            DescribeAliasResponse describeAliasResponse = (DescribeAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBuildResponse describeBuild(DescribeBuildRequest describeBuildRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBuild");
            DescribeBuildResponse describeBuildResponse = (DescribeBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBuild").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBuildRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBuildResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeBuildRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEc2InstanceLimitsResponse describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest describeEc2InstanceLimitsRequest) throws InvalidRequestException, InternalServiceException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEc2InstanceLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEC2InstanceLimits");
            DescribeEc2InstanceLimitsResponse describeEc2InstanceLimitsResponse = (DescribeEc2InstanceLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEC2InstanceLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEc2InstanceLimitsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEc2InstanceLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEc2InstanceLimitsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeEc2InstanceLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAttributesResponse describeFleetAttributes(DescribeFleetAttributesRequest describeFleetAttributesRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAttributes");
            DescribeFleetAttributesResponse describeFleetAttributesResponse = (DescribeFleetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeFleetAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetCapacityResponse describeFleetCapacity(DescribeFleetCapacityRequest describeFleetCapacityRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetCapacity");
            DescribeFleetCapacityResponse describeFleetCapacityResponse = (DescribeFleetCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetCapacityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetCapacityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeFleetCapacityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetEventsResponse describeFleetEvents(DescribeFleetEventsRequest describeFleetEventsRequest) throws NotFoundException, InternalServiceException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetEvents");
            DescribeFleetEventsResponse describeFleetEventsResponse = (DescribeFleetEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetEventsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetEventsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeFleetEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetPortSettingsResponse describeFleetPortSettings(DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetPortSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetPortSettings");
            DescribeFleetPortSettingsResponse describeFleetPortSettingsResponse = (DescribeFleetPortSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetPortSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetPortSettingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetPortSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetPortSettingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeFleetPortSettingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetUtilizationResponse describeFleetUtilization(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetUtilization");
            DescribeFleetUtilizationResponse describeFleetUtilizationResponse = (DescribeFleetUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetUtilization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetUtilizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetUtilizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeFleetUtilizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameServerResponse describeGameServer(DescribeGameServerRequest describeGameServerRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameServer");
            DescribeGameServerResponse describeGameServerResponse = (DescribeGameServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameServerGroupResponse describeGameServerGroup(DescribeGameServerGroupRequest describeGameServerGroupRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameServerGroup");
            DescribeGameServerGroupResponse describeGameServerGroupResponse = (DescribeGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionDetailsResponse describeGameSessionDetails(DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameSessionDetails");
            DescribeGameSessionDetailsResponse describeGameSessionDetailsResponse = (DescribeGameSessionDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameSessionDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionDetailsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameSessionDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameSessionDetailsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameSessionDetailsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionPlacementResponse describeGameSessionPlacement(DescribeGameSessionPlacementRequest describeGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameSessionPlacement");
            DescribeGameSessionPlacementResponse describeGameSessionPlacementResponse = (DescribeGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameSessionPlacement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionPlacementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameSessionPlacementResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameSessionPlacementRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionQueuesResponse describeGameSessionQueues(DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionQueuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameSessionQueues");
            DescribeGameSessionQueuesResponse describeGameSessionQueuesResponse = (DescribeGameSessionQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameSessionQueues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionQueuesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameSessionQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameSessionQueuesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameSessionQueuesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionsResponse describeGameSessions(DescribeGameSessionsRequest describeGameSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGameSessions");
            DescribeGameSessionsResponse describeGameSessionsResponse = (DescribeGameSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGameSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGameSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGameSessionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeGameSessionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstancesResponse describeInstances(DescribeInstancesRequest describeInstancesRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstances");
            DescribeInstancesResponse describeInstancesResponse = (DescribeInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInstancesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMatchmakingResponse describeMatchmaking(DescribeMatchmakingRequest describeMatchmakingRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMatchmaking");
            DescribeMatchmakingResponse describeMatchmakingResponse = (DescribeMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMatchmaking").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMatchmakingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeMatchmakingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMatchmakingConfigurations");
            DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurationsResponse = (DescribeMatchmakingConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMatchmakingConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingConfigurationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMatchmakingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMatchmakingConfigurationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeMatchmakingConfigurationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) throws InvalidRequestException, InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingRuleSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMatchmakingRuleSets");
            DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSetsResponse = (DescribeMatchmakingRuleSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMatchmakingRuleSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingRuleSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMatchmakingRuleSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMatchmakingRuleSetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeMatchmakingRuleSetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePlayerSessionsResponse describePlayerSessions(DescribePlayerSessionsRequest describePlayerSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePlayerSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePlayerSessions");
            DescribePlayerSessionsResponse describePlayerSessionsResponse = (DescribePlayerSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePlayerSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePlayerSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribePlayerSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePlayerSessionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describePlayerSessionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuntimeConfigurationResponse describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuntimeConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRuntimeConfiguration");
            DescribeRuntimeConfigurationResponse describeRuntimeConfigurationResponse = (DescribeRuntimeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRuntimeConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuntimeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRuntimeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRuntimeConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeRuntimeConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingPoliciesResponse describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingPolicies");
            DescribeScalingPoliciesResponse describeScalingPoliciesResponse = (DescribeScalingPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingPoliciesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScalingPoliciesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeScalingPoliciesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScriptResponse describeScript(DescribeScriptRequest describeScriptRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScriptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScript");
            DescribeScriptResponse describeScriptResponse = (DescribeScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScript").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScriptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScriptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeScriptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest describeVpcPeeringAuthorizationsRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcPeeringAuthorizationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVpcPeeringAuthorizations");
            DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizationsResponse = (DescribeVpcPeeringAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVpcPeeringAuthorizations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVpcPeeringAuthorizationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVpcPeeringAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVpcPeeringAuthorizationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeVpcPeeringAuthorizationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcPeeringConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVpcPeeringConnections");
            DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnectionsResponse = (DescribeVpcPeeringConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVpcPeeringConnections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVpcPeeringConnectionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVpcPeeringConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVpcPeeringConnectionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, describeVpcPeeringConnectionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGameSessionLogUrlResponse getGameSessionLogUrl(GetGameSessionLogUrlRequest getGameSessionLogUrlRequest) throws InternalServiceException, NotFoundException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGameSessionLogUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGameSessionLogUrl");
            GetGameSessionLogUrlResponse getGameSessionLogUrlResponse = (GetGameSessionLogUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGameSessionLogUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGameSessionLogUrlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetGameSessionLogUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGameSessionLogUrlResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, getGameSessionLogUrlRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceAccessResponse getInstanceAccess(GetInstanceAccessRequest getInstanceAccessRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceAccess");
            GetInstanceAccessResponse getInstanceAccessResponse = (GetInstanceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInstanceAccessRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceAccessResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, getInstanceAccessRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAliases");
            ListAliasesResponse listAliasesResponse = (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAliasesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listAliasesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuilds");
            ListBuildsResponse listBuildsResponse = (ListBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuilds").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuildsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListBuildsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuildsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listBuildsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFleetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFleets");
            ListFleetsResponse listFleetsResponse = (ListFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFleets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFleetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFleetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listFleetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGameServerGroupsResponse listGameServerGroups(ListGameServerGroupsRequest listGameServerGroupsRequest) throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGameServerGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGameServerGroups");
            ListGameServerGroupsResponse listGameServerGroupsResponse = (ListGameServerGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGameServerGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGameServerGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListGameServerGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGameServerGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listGameServerGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGameServersResponse listGameServers(ListGameServersRequest listGameServersRequest) throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGameServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGameServers");
            ListGameServersResponse listGameServersResponse = (ListGameServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGameServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGameServersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListGameServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGameServersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listGameServersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListScriptsResponse listScripts(ListScriptsRequest listScriptsRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScriptsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScripts");
            ListScriptsResponse listScriptsResponse = (ListScriptsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScripts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listScriptsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListScriptsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listScriptsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listScriptsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScalingPolicy");
            PutScalingPolicyResponse putScalingPolicyResponse = (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putScalingPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, putScalingPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterGameServerResponse registerGameServer(RegisterGameServerRequest registerGameServerRequest) throws InvalidRequestException, ConflictException, UnauthorizedException, InternalServiceException, LimitExceededException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterGameServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterGameServer");
            RegisterGameServerResponse registerGameServerResponse = (RegisterGameServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterGameServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerGameServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RegisterGameServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerGameServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, registerGameServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestUploadCredentialsResponse requestUploadCredentials(RequestUploadCredentialsRequest requestUploadCredentialsRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestUploadCredentialsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestUploadCredentials");
            RequestUploadCredentialsResponse requestUploadCredentialsResponse = (RequestUploadCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestUploadCredentials").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestUploadCredentialsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RequestUploadCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return requestUploadCredentialsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, requestUploadCredentialsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveAliasResponse resolveAlias(ResolveAliasRequest resolveAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, TerminalRoutingStrategyException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResolveAlias");
            ResolveAliasResponse resolveAliasResponse = (ResolveAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resolveAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ResolveAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resolveAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, resolveAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeGameServerGroupResponse resumeGameServerGroup(ResumeGameServerGroupRequest resumeGameServerGroupRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeGameServerGroup");
            ResumeGameServerGroupResponse resumeGameServerGroupResponse = (ResumeGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ResumeGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resumeGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, resumeGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchGameSessionsResponse searchGameSessions(SearchGameSessionsRequest searchGameSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchGameSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchGameSessions");
            SearchGameSessionsResponse searchGameSessionsResponse = (SearchGameSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchGameSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchGameSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SearchGameSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchGameSessionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, searchGameSessionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFleetActionsResponse startFleetActions(StartFleetActionsRequest startFleetActionsRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFleetActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFleetActions");
            StartFleetActionsResponse startFleetActionsResponse = (StartFleetActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFleetActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFleetActionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartFleetActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFleetActionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, startFleetActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartGameSessionPlacementResponse startGameSessionPlacement(StartGameSessionPlacementRequest startGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartGameSessionPlacement");
            StartGameSessionPlacementResponse startGameSessionPlacementResponse = (StartGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartGameSessionPlacement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startGameSessionPlacementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startGameSessionPlacementResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, startGameSessionPlacementRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMatchBackfillResponse startMatchBackfill(StartMatchBackfillRequest startMatchBackfillRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMatchBackfillResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMatchBackfill");
            StartMatchBackfillResponse startMatchBackfillResponse = (StartMatchBackfillResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMatchBackfill").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMatchBackfillRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartMatchBackfillRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMatchBackfillResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, startMatchBackfillRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMatchmakingResponse startMatchmaking(StartMatchmakingRequest startMatchmakingRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMatchmaking");
            StartMatchmakingResponse startMatchmakingResponse = (StartMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMatchmaking").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMatchmakingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMatchmakingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, startMatchmakingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopFleetActionsResponse stopFleetActions(StopFleetActionsRequest stopFleetActionsRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFleetActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFleetActions");
            StopFleetActionsResponse stopFleetActionsResponse = (StopFleetActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFleetActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopFleetActionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StopFleetActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopFleetActionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, stopFleetActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopGameSessionPlacementResponse stopGameSessionPlacement(StopGameSessionPlacementRequest stopGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopGameSessionPlacement");
            StopGameSessionPlacementResponse stopGameSessionPlacementResponse = (StopGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopGameSessionPlacement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopGameSessionPlacementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StopGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopGameSessionPlacementResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, stopGameSessionPlacementRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopMatchmakingResponse stopMatchmaking(StopMatchmakingRequest stopMatchmakingRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopMatchmaking");
            StopMatchmakingResponse stopMatchmakingResponse = (StopMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopMatchmaking").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopMatchmakingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StopMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopMatchmakingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, stopMatchmakingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuspendGameServerGroupResponse suspendGameServerGroup(SuspendGameServerGroupRequest suspendGameServerGroupRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SuspendGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SuspendGameServerGroup");
            SuspendGameServerGroupResponse suspendGameServerGroupResponse = (SuspendGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SuspendGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)suspendGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SuspendGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return suspendGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, suspendGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlias");
            UpdateAliasResponse updateAliasResponse = (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBuildResponse updateBuild(UpdateBuildRequest updateBuildRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBuild");
            UpdateBuildResponse updateBuildResponse = (UpdateBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBuild").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBuildRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBuildResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateBuildRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetAttributesResponse updateFleetAttributes(UpdateFleetAttributesRequest updateFleetAttributesRequest) throws NotFoundException, ConflictException, InvalidFleetStatusException, LimitExceededException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFleetAttributes");
            UpdateFleetAttributesResponse updateFleetAttributesResponse = (UpdateFleetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFleetAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFleetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFleetAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateFleetAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetCapacityResponse updateFleetCapacity(UpdateFleetCapacityRequest updateFleetCapacityRequest) throws NotFoundException, ConflictException, LimitExceededException, InvalidFleetStatusException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFleetCapacity");
            UpdateFleetCapacityResponse updateFleetCapacityResponse = (UpdateFleetCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFleetCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetCapacityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFleetCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFleetCapacityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateFleetCapacityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetPortSettingsResponse updateFleetPortSettings(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) throws NotFoundException, ConflictException, InvalidFleetStatusException, LimitExceededException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetPortSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFleetPortSettings");
            UpdateFleetPortSettingsResponse updateFleetPortSettingsResponse = (UpdateFleetPortSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFleetPortSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetPortSettingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFleetPortSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFleetPortSettingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateFleetPortSettingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameServerResponse updateGameServer(UpdateGameServerRequest updateGameServerRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGameServer");
            UpdateGameServerResponse updateGameServerResponse = (UpdateGameServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGameServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateGameServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameServerGroupResponse updateGameServerGroup(UpdateGameServerGroupRequest updateGameServerGroupRequest) throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameServerGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGameServerGroup");
            UpdateGameServerGroupResponse updateGameServerGroupResponse = (UpdateGameServerGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGameServerGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameServerGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameServerGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameServerGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateGameServerGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameSessionResponse updateGameSession(UpdateGameSessionRequest updateGameSessionRequest) throws NotFoundException, ConflictException, InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGameSession");
            UpdateGameSessionResponse updateGameSessionResponse = (UpdateGameSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGameSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateGameSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameSessionQueueResponse updateGameSessionQueue(UpdateGameSessionQueueRequest updateGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGameSessionQueue");
            UpdateGameSessionQueueResponse updateGameSessionQueueResponse = (UpdateGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGameSessionQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameSessionQueueRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameSessionQueueResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateGameSessionQueueRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMatchmakingConfigurationResponse updateMatchmakingConfiguration(UpdateMatchmakingConfigurationRequest updateMatchmakingConfigurationRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMatchmakingConfiguration");
            UpdateMatchmakingConfigurationResponse updateMatchmakingConfigurationResponse = (UpdateMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMatchmakingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMatchmakingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMatchmakingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateMatchmakingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuntimeConfigurationResponse updateRuntimeConfiguration(UpdateRuntimeConfigurationRequest updateRuntimeConfigurationRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException, InvalidFleetStatusException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuntimeConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRuntimeConfiguration");
            UpdateRuntimeConfigurationResponse updateRuntimeConfigurationResponse = (UpdateRuntimeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuntimeConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuntimeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRuntimeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRuntimeConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateRuntimeConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScriptResponse updateScript(UpdateScriptRequest updateScriptRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScriptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScript");
            UpdateScriptResponse updateScriptResponse = (UpdateScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScript").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateScriptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateScriptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, updateScriptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateMatchmakingRuleSetResponse validateMatchmakingRuleSet(ValidateMatchmakingRuleSetRequest validateMatchmakingRuleSetRequest) throws InternalServiceException, UnsupportedRegionException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateMatchmakingRuleSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidateMatchmakingRuleSet");
            ValidateMatchmakingRuleSetResponse validateMatchmakingRuleSetResponse = (ValidateMatchmakingRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateMatchmakingRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateMatchmakingRuleSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ValidateMatchmakingRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validateMatchmakingRuleSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGameLiftClient.resolveMetricPublishers(this.clientConfiguration, validateMatchmakingRuleSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GameLiftException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException").exceptionBuilderSupplier(FleetCapacityExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException").exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException").exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OutOfCapacityException").exceptionBuilderSupplier(OutOfCapacityException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GameSessionFullException").exceptionBuilderSupplier(GameSessionFullException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TaggingFailedException").exceptionBuilderSupplier(TaggingFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").exceptionBuilderSupplier(UnsupportedRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").exceptionBuilderSupplier(InvalidFleetStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

