/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopGameSessionPlacementResponse extends GameLiftResponse implements
        ToCopyableBuilder<StopGameSessionPlacementResponse.Builder, StopGameSessionPlacementResponse> {
    private static final SdkField<GameSessionPlacement> GAME_SESSION_PLACEMENT_FIELD = SdkField
            .<GameSessionPlacement> builder(MarshallingType.SDK_POJO)
            .getter(getter(StopGameSessionPlacementResponse::gameSessionPlacement)).setter(setter(Builder::gameSessionPlacement))
            .constructor(GameSessionPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionPlacement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_PLACEMENT_FIELD));

    private final GameSessionPlacement gameSessionPlacement;

    private StopGameSessionPlacementResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionPlacement = builder.gameSessionPlacement;
    }

    /**
     * <p>
     * Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time
     * stamp.
     * </p>
     * 
     * @return Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end
     *         time stamp.
     */
    public GameSessionPlacement gameSessionPlacement() {
        return gameSessionPlacement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionPlacement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopGameSessionPlacementResponse)) {
            return false;
        }
        StopGameSessionPlacementResponse other = (StopGameSessionPlacementResponse) obj;
        return Objects.equals(gameSessionPlacement(), other.gameSessionPlacement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopGameSessionPlacementResponse").add("GameSessionPlacement", gameSessionPlacement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionPlacement":
            return Optional.ofNullable(clazz.cast(gameSessionPlacement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopGameSessionPlacementResponse, T> g) {
        return obj -> g.apply((StopGameSessionPlacementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopGameSessionPlacementResponse> {
        /**
         * <p>
         * Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time
         * stamp.
         * </p>
         * 
         * @param gameSessionPlacement
         *        Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an
         *        end time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionPlacement(GameSessionPlacement gameSessionPlacement);

        /**
         * <p>
         * Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time
         * stamp.
         * </p>
         * This is a convenience that creates an instance of the {@link GameSessionPlacement.Builder} avoiding the need
         * to create one manually via {@link GameSessionPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameSessionPlacement.Builder#build()} is called immediately and
         * its result is passed to {@link #gameSessionPlacement(GameSessionPlacement)}.
         * 
         * @param gameSessionPlacement
         *        a consumer that will call methods on {@link GameSessionPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessionPlacement(GameSessionPlacement)
         */
        default Builder gameSessionPlacement(Consumer<GameSessionPlacement.Builder> gameSessionPlacement) {
            return gameSessionPlacement(GameSessionPlacement.builder().applyMutation(gameSessionPlacement).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameSessionPlacement gameSessionPlacement;

        private BuilderImpl() {
        }

        private BuilderImpl(StopGameSessionPlacementResponse model) {
            super(model);
            gameSessionPlacement(model.gameSessionPlacement);
        }

        public final GameSessionPlacement.Builder getGameSessionPlacement() {
            return gameSessionPlacement != null ? gameSessionPlacement.toBuilder() : null;
        }

        @Override
        public final Builder gameSessionPlacement(GameSessionPlacement gameSessionPlacement) {
            this.gameSessionPlacement = gameSessionPlacement;
            return this;
        }

        public final void setGameSessionPlacement(GameSessionPlacement.BuilderImpl gameSessionPlacement) {
            this.gameSessionPlacement = gameSessionPlacement != null ? gameSessionPlacement.build() : null;
        }

        @Override
        public StopGameSessionPlacementResponse build() {
            return new StopGameSessionPlacementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
