/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The routing configuration for a fleet alias.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListAliases</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ResolveAlias</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingStrategy implements SdkPojo, Serializable, ToCopyableBuilder<RoutingStrategy.Builder, RoutingStrategy> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RoutingStrategy::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RoutingStrategy::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RoutingStrategy::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, FLEET_ID_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String fleetId;

    private final String message;

    private RoutingStrategy(BuilderImpl builder) {
        this.type = builder.type;
        this.fleetId = builder.fleetId;
        this.message = builder.message;
    }

    /**
     * <p>
     * The type of routing strategy for the alias.
     * </p>
     * <p>
     * Possible routing types include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user.
     * A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoutingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of routing strategy for the alias.</p>
     *         <p>
     *         Possible routing types include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to
     *         the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a>
     *         message embedded.
     *         </p>
     *         </li>
     * @see RoutingStrategyType
     */
    public RoutingStrategyType type() {
        return RoutingStrategyType.fromValue(type);
    }

    /**
     * <p>
     * The type of routing strategy for the alias.
     * </p>
     * <p>
     * Possible routing types include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user.
     * A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoutingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of routing strategy for the alias.</p>
     *         <p>
     *         Possible routing types include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to
     *         the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a>
     *         message embedded.
     *         </p>
     *         </li>
     * @see RoutingStrategyType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The unique identifier for a fleet that the alias points to. This value is the fleet ID, not the fleet ARN.
     * </p>
     * 
     * @return The unique identifier for a fleet that the alias points to. This value is the fleet ID, not the fleet
     *         ARN.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The message text to be used with a terminal routing strategy.
     * </p>
     * 
     * @return The message text to be used with a terminal routing strategy.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingStrategy)) {
            return false;
        }
        RoutingStrategy other = (RoutingStrategy) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RoutingStrategy").add("Type", typeAsString()).add("FleetId", fleetId())
                .add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingStrategy, T> g) {
        return obj -> g.apply((RoutingStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingStrategy> {
        /**
         * <p>
         * The type of routing strategy for the alias.
         * </p>
         * <p>
         * Possible routing types include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the
         * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
         * embedded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of routing strategy for the alias.</p>
         *        <p>
         *        Possible routing types include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message
         *        to the user. A terminal alias throws a TerminalRoutingStrategyException with the
         *        <a>RoutingStrategy</a> message embedded.
         *        </p>
         *        </li>
         * @see RoutingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of routing strategy for the alias.
         * </p>
         * <p>
         * Possible routing types include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the
         * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
         * embedded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of routing strategy for the alias.</p>
         *        <p>
         *        Possible routing types include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message
         *        to the user. A terminal alias throws a TerminalRoutingStrategyException with the
         *        <a>RoutingStrategy</a> message embedded.
         *        </p>
         *        </li>
         * @see RoutingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategyType
         */
        Builder type(RoutingStrategyType type);

        /**
         * <p>
         * The unique identifier for a fleet that the alias points to. This value is the fleet ID, not the fleet ARN.
         * </p>
         * 
         * @param fleetId
         *        The unique identifier for a fleet that the alias points to. This value is the fleet ID, not the fleet
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The message text to be used with a terminal routing strategy.
         * </p>
         * 
         * @param message
         *        The message text to be used with a terminal routing strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String fleetId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingStrategy model) {
            type(model.type);
            fleetId(model.fleetId);
            message(model.message);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoutingStrategyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public RoutingStrategy build() {
            return new RoutingStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
