/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a player session that was created as part of a <a>StartGameSessionPlacement</a> request. This
 * object contains only the player ID and player session ID. To retrieve full details on a player session, call
 * <a>DescribePlayerSessions</a> with the player session ID.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreatePlayerSession</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreatePlayerSessions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribePlayerSessions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Game session placements
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>StartGameSessionPlacement</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeGameSessionPlacement</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopGameSessionPlacement</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacedPlayerSession implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacedPlayerSession.Builder, PlacedPlayerSession> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacedPlayerSession::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()).build();

    private static final SdkField<String> PLAYER_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacedPlayerSession::playerSessionId)).setter(setter(Builder::playerSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD,
            PLAYER_SESSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String playerId;

    private final String playerSessionId;

    private PlacedPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
    }

    /**
     * <p>
     * A unique identifier for a player that is associated with this player session.
     * </p>
     * 
     * @return A unique identifier for a player that is associated with this player session.
     */
    public String playerId() {
        return playerId;
    }

    /**
     * <p>
     * A unique identifier for a player session.
     * </p>
     * 
     * @return A unique identifier for a player session.
     */
    public String playerSessionId() {
        return playerSessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(playerSessionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacedPlayerSession)) {
            return false;
        }
        PlacedPlayerSession other = (PlacedPlayerSession) obj;
        return Objects.equals(playerId(), other.playerId()) && Objects.equals(playerSessionId(), other.playerSessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacedPlayerSession").add("PlayerId", playerId()).add("PlayerSessionId", playerSessionId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "PlayerSessionId":
            return Optional.ofNullable(clazz.cast(playerSessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacedPlayerSession, T> g) {
        return obj -> g.apply((PlacedPlayerSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacedPlayerSession> {
        /**
         * <p>
         * A unique identifier for a player that is associated with this player session.
         * </p>
         * 
         * @param playerId
         *        A unique identifier for a player that is associated with this player session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * A unique identifier for a player session.
         * </p>
         * 
         * @param playerSessionId
         *        A unique identifier for a player session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerSessionId(String playerSessionId);
    }

    static final class BuilderImpl implements Builder {
        private String playerId;

        private String playerSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacedPlayerSession model) {
            playerId(model.playerId);
            playerSessionId(model.playerSessionId);
        }

        public final String getPlayerId() {
            return playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        @Override
        public PlacedPlayerSession build() {
            return new PlacedPlayerSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
