/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is part of Amazon GameLift FleetIQ with game server groups, which is in preview release and is
 * subject to change.</b>
 * </p>
 * <p>
 * Configuration settings for intelligent autoscaling that uses target tracking. An autoscaling policy can be specified
 * when a new game server group is created with <a>CreateGameServerGroup</a>. If a group has an autoscaling policy, the
 * Auto Scaling group takes action based on this policy, in addition to (and potentially in conflict with) any other
 * autoscaling policies that are separately applied to the Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GameServerGroupAutoScalingPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<GameServerGroupAutoScalingPolicy.Builder, GameServerGroupAutoScalingPolicy> {
    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GameServerGroupAutoScalingPolicy::estimatedInstanceWarmup))
            .setter(setter(Builder::estimatedInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build())
            .build();

    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField
            .<TargetTrackingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GameServerGroupAutoScalingPolicy::targetTrackingConfiguration))
            .setter(setter(Builder::targetTrackingConfiguration))
            .constructor(TargetTrackingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_INSTANCE_WARMUP_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer estimatedInstanceWarmup;

    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private GameServerGroupAutoScalingPolicy(BuilderImpl builder) {
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    /**
     * <p>
     * Length of time, in seconds, it takes for a new instance to start new game server processes and register with
     * GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time
     * to start up, because it avoids prematurely starting new instances
     * </p>
     * 
     * @return Length of time, in seconds, it takes for a new instance to start new game server processes and register
     *         with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take
     *         a long time to start up, because it avoids prematurely starting new instances
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    /**
     * <p>
     * Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a
     * target-based policy that tracks the GameLift FleetIQ metric "PercentUtilizedGameServers" and specifies a target
     * value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so
     * that the metric returns to the target value.
     * </p>
     * 
     * @return Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to
     *         create a target-based policy that tracks the GameLift FleetIQ metric "PercentUtilizedGameServers" and
     *         specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game
     *         server group capacity so that the metric returns to the target value.
     */
    public TargetTrackingConfiguration targetTrackingConfiguration() {
        return targetTrackingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServerGroupAutoScalingPolicy)) {
            return false;
        }
        GameServerGroupAutoScalingPolicy other = (GameServerGroupAutoScalingPolicy) obj;
        return Objects.equals(estimatedInstanceWarmup(), other.estimatedInstanceWarmup())
                && Objects.equals(targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GameServerGroupAutoScalingPolicy").add("EstimatedInstanceWarmup", estimatedInstanceWarmup())
                .add("TargetTrackingConfiguration", targetTrackingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedInstanceWarmup":
            return Optional.ofNullable(clazz.cast(estimatedInstanceWarmup()));
        case "TargetTrackingConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameServerGroupAutoScalingPolicy, T> g) {
        return obj -> g.apply((GameServerGroupAutoScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GameServerGroupAutoScalingPolicy> {
        /**
         * <p>
         * Length of time, in seconds, it takes for a new instance to start new game server processes and register with
         * GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long
         * time to start up, because it avoids prematurely starting new instances
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        Length of time, in seconds, it takes for a new instance to start new game server processes and
         *        register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game
         *        servers that take a long time to start up, because it avoids prematurely starting new instances
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);

        /**
         * <p>
         * Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a
         * target-based policy that tracks the GameLift FleetIQ metric "PercentUtilizedGameServers" and specifies a
         * target value for the metric. As player usage changes, the policy triggers to adjust the game server group
         * capacity so that the metric returns to the target value.
         * </p>
         * 
         * @param targetTrackingConfiguration
         *        Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to
         *        create a target-based policy that tracks the GameLift FleetIQ metric "PercentUtilizedGameServers" and
         *        specifies a target value for the metric. As player usage changes, the policy triggers to adjust the
         *        game server group capacity so that the metric returns to the target value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration);

        /**
         * <p>
         * Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a
         * target-based policy that tracks the GameLift FleetIQ metric "PercentUtilizedGameServers" and specifies a
         * target value for the metric. As player usage changes, the policy triggers to adjust the game server group
         * capacity so that the metric returns to the target value.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetTrackingConfiguration.Builder} avoiding
         * the need to create one manually via {@link TargetTrackingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetTrackingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetTrackingConfiguration(TargetTrackingConfiguration)}.
         * 
         * @param targetTrackingConfiguration
         *        a consumer that will call methods on {@link TargetTrackingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingConfiguration(TargetTrackingConfiguration)
         */
        default Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return targetTrackingConfiguration(TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer estimatedInstanceWarmup;

        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServerGroupAutoScalingPolicy model) {
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return targetTrackingConfiguration != null ? targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public GameServerGroupAutoScalingPolicy build() {
            return new GameServerGroupAutoScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
