/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties describing a custom game build.
 * </p>
 * <p>
 * <b>Related operations</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateBuild</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListBuilds</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeBuild</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateBuild</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteBuild</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Build implements SdkPojo, Serializable, ToCopyableBuilder<Build.Builder, Build> {
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::buildId)).setter(setter(Builder::buildId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()).build();

    private static final SdkField<String> BUILD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::buildArn)).setter(setter(Builder::buildArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> SIZE_ON_DISK_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Build::sizeOnDisk)).setter(setter(Builder::sizeOnDisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeOnDisk").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Build::operatingSystemAsString)).setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Build::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_ID_FIELD,
            BUILD_ARN_FIELD, NAME_FIELD, VERSION_FIELD, STATUS_FIELD, SIZE_ON_DISK_FIELD, OPERATING_SYSTEM_FIELD,
            CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String buildId;

    private final String buildArn;

    private final String name;

    private final String version;

    private final String status;

    private final Long sizeOnDisk;

    private final String operatingSystem;

    private final Instant creationTime;

    private Build(BuilderImpl builder) {
        this.buildId = builder.buildId;
        this.buildArn = builder.buildArn;
        this.name = builder.name;
        this.version = builder.version;
        this.status = builder.status;
        this.sizeOnDisk = builder.sizeOnDisk;
        this.operatingSystem = builder.operatingSystem;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * A unique identifier for a build.
     * </p>
     * 
     * @return A unique identifier for a build.
     */
    public String buildId() {
        return buildId;
    }

    /**
     * <p>
     * Amazon Resource Name (<a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned to a
     * GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift build ARN,
     * the resource ID matches the <i>BuildId</i> value.
     * </p>
     * 
     * @return Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
     *         assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. In
     *         a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.
     */
    public String buildArn() {
        return buildArn;
    }

    /**
     * <p>
     * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using
     * <a>CreateBuild</a> or <a>UpdateBuild</a>.
     * </p>
     * 
     * @return A descriptive label that is associated with a build. Build names do not need to be unique. It can be set
     *         using <a>CreateBuild</a> or <a>UpdateBuild</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Version information that is associated with a build or script. Version strings do not need to be unique. This
     * value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.
     * </p>
     * 
     * @return Version information that is associated with a build or script. Version strings do not need to be unique.
     *         This value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Current status of the build.
     * </p>
     * <p>
     * Possible build statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for
     * builds that are in this status. When a build is successfully created, the build status is set to this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the build.</p>
     *         <p>
     *         Possible build statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
     *         fleets for builds that are in this status. When a build is successfully created, the build status is set
     *         to this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
     *         build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     *         </p>
     *         </li>
     * @see BuildStatus
     */
    public BuildStatus status() {
        return BuildStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the build.
     * </p>
     * <p>
     * Possible build statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for
     * builds that are in this status. When a build is successfully created, the build status is set to this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the build.</p>
     *         <p>
     *         Possible build statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
     *         fleets for builds that are in this status. When a build is successfully created, the build status is set
     *         to this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
     *         build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     *         </p>
     *         </li>
     * @see BuildStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code>, this
     * value is 0.
     * </p>
     * 
     * @return File size of the uploaded game build, expressed in bytes. When the build status is
     *         <code>INITIALIZED</code>, this value is 0.
     */
    public Long sizeOnDisk() {
        return sizeOnDisk;
    }

    /**
     * <p>
     * Operating system that the game server binaries are built to run on. This value determines the type of fleet
     * resources that you can use for this build.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Operating system that the game server binaries are built to run on. This value determines the type of
     *         fleet resources that you can use for this build.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Operating system that the game server binaries are built to run on. This value determines the type of fleet
     * resources that you can use for this build.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Operating system that the game server binaries are built to run on. This value determines the type of
     *         fleet resources that you can use for this build.
     * @see OperatingSystem
     */
    public String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(buildId());
        hashCode = 31 * hashCode + Objects.hashCode(buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeOnDisk());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build) obj;
        return Objects.equals(buildId(), other.buildId()) && Objects.equals(buildArn(), other.buildArn())
                && Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(sizeOnDisk(), other.sizeOnDisk())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Build").add("BuildId", buildId()).add("BuildArn", buildArn()).add("Name", name())
                .add("Version", version()).add("Status", statusAsString()).add("SizeOnDisk", sizeOnDisk())
                .add("OperatingSystem", operatingSystemAsString()).add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BuildId":
            return Optional.ofNullable(clazz.cast(buildId()));
        case "BuildArn":
            return Optional.ofNullable(clazz.cast(buildArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SizeOnDisk":
            return Optional.ofNullable(clazz.cast(sizeOnDisk()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Build, T> g) {
        return obj -> g.apply((Build) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Build> {
        /**
         * <p>
         * A unique identifier for a build.
         * </p>
         * 
         * @param buildId
         *        A unique identifier for a build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildId(String buildId);

        /**
         * <p>
         * Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned
         * to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift
         * build ARN, the resource ID matches the <i>BuildId</i> value.
         * </p>
         * 
         * @param buildArn
         *        Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
         *        assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions.
         *        In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildArn(String buildArn);

        /**
         * <p>
         * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set
         * using <a>CreateBuild</a> or <a>UpdateBuild</a>.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a build. Build names do not need to be unique. It can be
         *        set using <a>CreateBuild</a> or <a>UpdateBuild</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Version information that is associated with a build or script. Version strings do not need to be unique. This
         * value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.
         * </p>
         * 
         * @param version
         *        Version information that is associated with a build or script. Version strings do not need to be
         *        unique. This value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Current status of the build.
         * </p>
         * <p>
         * Possible build statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets
         * for builds that are in this status. When a build is successfully created, the build status is set to this
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Current status of the build.</p>
         *        <p>
         *        Possible build statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
         *        fleets for builds that are in this status. When a build is successfully created, the build status is
         *        set to this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
         *        build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         *        </p>
         *        </li>
         * @see BuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the build.
         * </p>
         * <p>
         * Possible build statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets
         * for builds that are in this status. When a build is successfully created, the build status is set to this
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Current status of the build.</p>
         *        <p>
         *        Possible build statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
         *        fleets for builds that are in this status. When a build is successfully created, the build status is
         *        set to this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
         *        build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         *        </p>
         *        </li>
         * @see BuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildStatus
         */
        Builder status(BuildStatus status);

        /**
         * <p>
         * File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code>,
         * this value is 0.
         * </p>
         * 
         * @param sizeOnDisk
         *        File size of the uploaded game build, expressed in bytes. When the build status is
         *        <code>INITIALIZED</code>, this value is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeOnDisk(Long sizeOnDisk);

        /**
         * <p>
         * Operating system that the game server binaries are built to run on. This value determines the type of fleet
         * resources that you can use for this build.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system that the game server binaries are built to run on. This value determines the type of
         *        fleet resources that you can use for this build.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Operating system that the game server binaries are built to run on. This value determines the type of fleet
         * resources that you can use for this build.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system that the game server binaries are built to run on. This value determines the type of
         *        fleet resources that you can use for this build.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param creationTime
         *        Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         *        milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String buildId;

        private String buildArn;

        private String name;

        private String version;

        private String status;

        private Long sizeOnDisk;

        private String operatingSystem;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            buildId(model.buildId);
            buildArn(model.buildArn);
            name(model.name);
            version(model.version);
            status(model.status);
            sizeOnDisk(model.sizeOnDisk);
            operatingSystem(model.operatingSystem);
            creationTime(model.creationTime);
        }

        public final String getBuildId() {
            return buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getBuildArn() {
            return buildArn;
        }

        @Override
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BuildStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getSizeOnDisk() {
            return sizeOnDisk;
        }

        @Override
        public final Builder sizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
            return this;
        }

        public final void setSizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public Build build() {
            return new Build(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
