/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupAction;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResumeGameServerGroupRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, ResumeGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResumeGameServerGroupRequest.getter(ResumeGameServerGroupRequest::gameServerGroupName)).setter(ResumeGameServerGroupRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<List<String>> RESUME_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResumeGameServerGroupRequest.getter(ResumeGameServerGroupRequest::resumeActionsAsStrings)).setter(ResumeGameServerGroupRequest.setter(Builder::resumeActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, RESUME_ACTIONS_FIELD));
    private final String gameServerGroupName;
    private final List<String> resumeActions;

    private ResumeGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.resumeActions = builder.resumeActions;
    }

    public String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public List<GameServerGroupAction> resumeActions() {
        return GameServerGroupActionsCopier.copyStringToEnum(this.resumeActions);
    }

    public boolean hasResumeActions() {
        return this.resumeActions != null && !(this.resumeActions instanceof SdkAutoConstructList);
    }

    public List<String> resumeActionsAsStrings() {
        return this.resumeActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resumeActionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeGameServerGroupRequest)) {
            return false;
        }
        ResumeGameServerGroupRequest other = (ResumeGameServerGroupRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.resumeActionsAsStrings(), other.resumeActionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ResumeGameServerGroupRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("ResumeActions", this.resumeActionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "ResumeActions": {
                return Optional.ofNullable(clazz.cast(this.resumeActionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeGameServerGroupRequest, T> g) {
        return obj -> g.apply((ResumeGameServerGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private List<String> resumeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeGameServerGroupRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.resumeActionsWithStrings(model.resumeActions);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final Collection<String> getResumeActionsAsStrings() {
            return this.resumeActions;
        }

        @Override
        public final Builder resumeActionsWithStrings(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActionsWithStrings(String ... resumeActions) {
            this.resumeActionsWithStrings(Arrays.asList(resumeActions));
            return this;
        }

        @Override
        public final Builder resumeActions(Collection<GameServerGroupAction> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copyEnumToString(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActions(GameServerGroupAction ... resumeActions) {
            this.resumeActions(Arrays.asList(resumeActions));
            return this;
        }

        public final void setResumeActionsWithStrings(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeGameServerGroupRequest build() {
            return new ResumeGameServerGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResumeGameServerGroupRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder resumeActionsWithStrings(Collection<String> var1);

        public Builder resumeActionsWithStrings(String ... var1);

        public Builder resumeActions(Collection<GameServerGroupAction> var1);

        public Builder resumeActions(GameServerGroupAction ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

