/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterGameServerRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, RegisterGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::gameServerGroupName)).setter(RegisterGameServerRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::gameServerId)).setter(RegisterGameServerRequest.setter(Builder::gameServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::instanceId)).setter(RegisterGameServerRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::connectionInfo)).setter(RegisterGameServerRequest.setter(Builder::connectionInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInfo").build()}).build();
    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::gameServerData)).setter(RegisterGameServerRequest.setter(Builder::gameServerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()}).build();
    private static final SdkField<String> CUSTOM_SORT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::customSortKey)).setter(RegisterGameServerRequest.setter(Builder::customSortKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSortKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterGameServerRequest.getter(RegisterGameServerRequest::tags)).setter(RegisterGameServerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_ID_FIELD, INSTANCE_ID_FIELD, CONNECTION_INFO_FIELD, GAME_SERVER_DATA_FIELD, CUSTOM_SORT_KEY_FIELD, TAGS_FIELD));
    private final String gameServerGroupName;
    private final String gameServerId;
    private final String instanceId;
    private final String connectionInfo;
    private final String gameServerData;
    private final String customSortKey;
    private final List<Tag> tags;

    private RegisterGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.instanceId = builder.instanceId;
        this.connectionInfo = builder.connectionInfo;
        this.gameServerData = builder.gameServerData;
        this.customSortKey = builder.customSortKey;
        this.tags = builder.tags;
    }

    public String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public String gameServerId() {
        return this.gameServerId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String connectionInfo() {
        return this.connectionInfo;
    }

    public String gameServerData() {
        return this.gameServerData;
    }

    public String customSortKey() {
        return this.customSortKey;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSortKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterGameServerRequest)) {
            return false;
        }
        RegisterGameServerRequest other = (RegisterGameServerRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerId(), other.gameServerId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.connectionInfo(), other.connectionInfo()) && Objects.equals(this.gameServerData(), other.gameServerData()) && Objects.equals(this.customSortKey(), other.customSortKey()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"RegisterGameServerRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerId", (Object)this.gameServerId()).add("InstanceId", (Object)this.instanceId()).add("ConnectionInfo", (Object)this.connectionInfo()).add("GameServerData", (Object)this.gameServerData()).add("CustomSortKey", (Object)this.customSortKey()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerId": {
                return Optional.ofNullable(clazz.cast(this.gameServerId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.connectionInfo()));
            }
            case "GameServerData": {
                return Optional.ofNullable(clazz.cast(this.gameServerData()));
            }
            case "CustomSortKey": {
                return Optional.ofNullable(clazz.cast(this.customSortKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterGameServerRequest, T> g) {
        return obj -> g.apply((RegisterGameServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerId;
        private String instanceId;
        private String connectionInfo;
        private String gameServerData;
        private String customSortKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterGameServerRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerId(model.gameServerId);
            this.instanceId(model.instanceId);
            this.connectionInfo(model.connectionInfo);
            this.gameServerData(model.gameServerData);
            this.customSortKey(model.customSortKey);
            this.tags(model.tags);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final String getGameServerId() {
            return this.gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getConnectionInfo() {
            return this.connectionInfo;
        }

        @Override
        public final Builder connectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public final void setConnectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
        }

        public final String getGameServerData() {
            return this.gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        public final String getCustomSortKey() {
            return this.customSortKey;
        }

        @Override
        public final Builder customSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
            return this;
        }

        public final void setCustomSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterGameServerRequest build() {
            return new RegisterGameServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterGameServerRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerId(String var1);

        public Builder instanceId(String var1);

        public Builder connectionInfo(String var1);

        public Builder gameServerData(String var1);

        public Builder customSortKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

