/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the fleet's capacity. Fleet capacity is measured in EC2 instances. By default, new fleets have a
 * capacity of one instance, but can be updated as needed. The maximum number of instances for a fleet is determined by
 * the fleet's instance type.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListFleets</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Manage fleet actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>StartFleetActions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopFleetActions</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetCapacity implements SdkPojo, Serializable, ToCopyableBuilder<FleetCapacity.Builder, FleetCapacity> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetCapacity::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetCapacity::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<EC2InstanceCounts> INSTANCE_COUNTS_FIELD = SdkField
            .<EC2InstanceCounts> builder(MarshallingType.SDK_POJO).getter(getter(FleetCapacity::instanceCounts))
            .setter(setter(Builder::instanceCounts)).constructor(EC2InstanceCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            INSTANCE_TYPE_FIELD, INSTANCE_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String instanceType;

    private final EC2InstanceCounts instanceCounts;

    private FleetCapacity(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceType = builder.instanceType;
        this.instanceCounts = builder.instanceCounts;
    }

    /**
     * <p>
     * A unique identifier for a fleet.
     * </p>
     * 
     * @return A unique identifier for a fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *         computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *         computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Current status of fleet capacity.
     * </p>
     * 
     * @return Current status of fleet capacity.
     */
    public EC2InstanceCounts instanceCounts() {
        return instanceCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCounts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacity)) {
            return false;
        }
        FleetCapacity other = (FleetCapacity) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCounts(), other.instanceCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FleetCapacity").add("FleetId", fleetId()).add("InstanceType", instanceTypeAsString())
                .add("InstanceCounts", instanceCounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCounts":
            return Optional.ofNullable(clazz.cast(instanceCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetCapacity, T> g) {
        return obj -> g.apply((FleetCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetCapacity> {
        /**
         * <p>
         * A unique identifier for a fleet.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param instanceType
         *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         *        the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param instanceType
         *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         *        the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(EC2InstanceType instanceType);

        /**
         * <p>
         * Current status of fleet capacity.
         * </p>
         * 
         * @param instanceCounts
         *        Current status of fleet capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(EC2InstanceCounts instanceCounts);

        /**
         * <p>
         * Current status of fleet capacity.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2InstanceCounts.Builder} avoiding the need to
         * create one manually via {@link EC2InstanceCounts#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2InstanceCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceCounts(EC2InstanceCounts)}.
         * 
         * @param instanceCounts
         *        a consumer that will call methods on {@link EC2InstanceCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCounts(EC2InstanceCounts)
         */
        default Builder instanceCounts(Consumer<EC2InstanceCounts.Builder> instanceCounts) {
            return instanceCounts(EC2InstanceCounts.builder().applyMutation(instanceCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String instanceType;

        private EC2InstanceCounts instanceCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacity model) {
            fleetId(model.fleetId);
            instanceType(model.instanceType);
            instanceCounts(model.instanceCounts);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final EC2InstanceCounts.Builder getInstanceCounts() {
            return instanceCounts != null ? instanceCounts.toBuilder() : null;
        }

        @Override
        public final Builder instanceCounts(EC2InstanceCounts instanceCounts) {
            this.instanceCounts = instanceCounts;
            return this;
        }

        public final void setInstanceCounts(EC2InstanceCounts.BuilderImpl instanceCounts) {
            this.instanceCounts = instanceCounts != null ? instanceCounts.build() : null;
        }

        @Override
        public FleetCapacity build() {
            return new FleetCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
