/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maximum number of instances allowed based on the Amazon Elastic Compute Cloud (Amazon EC2) instance type.
 * Instance limits can be retrieved by calling <a>DescribeEC2InstanceLimits</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceLimit implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceLimit.Builder, EC2InstanceLimit> {
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2InstanceLimit::ec2InstanceTypeAsString)).setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()).build();

    private static final SdkField<Integer> CURRENT_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceLimit::currentInstances)).setter(setter(Builder::currentInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstances").build()).build();

    private static final SdkField<Integer> INSTANCE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceLimit::instanceLimit)).setter(setter(Builder::instanceLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_TYPE_FIELD,
            CURRENT_INSTANCES_FIELD, INSTANCE_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ec2InstanceType;

    private final Integer currentInstances;

    private final Integer instanceLimit;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *         computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *         computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * Number of instances of the specified type that are currently in use by this AWS account.
     * </p>
     * 
     * @return Number of instances of the specified type that are currently in use by this AWS account.
     */
    public Integer currentInstances() {
        return currentInstances;
    }

    /**
     * <p>
     * Number of instances allowed.
     * </p>
     * 
     * @return Number of instances allowed.
     */
    public Integer instanceLimit() {
        return instanceLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentInstances());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLimit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit) obj;
        return Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && Objects.equals(currentInstances(), other.currentInstances())
                && Objects.equals(instanceLimit(), other.instanceLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EC2InstanceLimit").add("EC2InstanceType", ec2InstanceTypeAsString())
                .add("CurrentInstances", currentInstances()).add("InstanceLimit", instanceLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "CurrentInstances":
            return Optional.ofNullable(clazz.cast(currentInstances()));
        case "InstanceLimit":
            return Optional.ofNullable(clazz.cast(instanceLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceLimit, T> g) {
        return obj -> g.apply((EC2InstanceLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceLimit> {
        /**
         * <p>
         * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         *        the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         *        the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(EC2InstanceType ec2InstanceType);

        /**
         * <p>
         * Number of instances of the specified type that are currently in use by this AWS account.
         * </p>
         * 
         * @param currentInstances
         *        Number of instances of the specified type that are currently in use by this AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInstances(Integer currentInstances);

        /**
         * <p>
         * Number of instances allowed.
         * </p>
         * 
         * @param instanceLimit
         *        Number of instances allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceLimit(Integer instanceLimit);
    }

    static final class BuilderImpl implements Builder {
        private String ec2InstanceType;

        private Integer currentInstances;

        private Integer instanceLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            ec2InstanceType(model.ec2InstanceType);
            currentInstances(model.currentInstances);
            instanceLimit(model.instanceLimit);
        }

        public final String getEc2InstanceTypeAsString() {
            return ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Integer getCurrentInstances() {
            return currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        public final Integer getInstanceLimit() {
            return instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        @Override
        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
