/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScriptResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeScriptResponse.Builder, DescribeScriptResponse> {
    private static final SdkField<Script> SCRIPT_FIELD = SdkField.<Script> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeScriptResponse::script)).setter(setter(Builder::script)).constructor(Script::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Script").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_FIELD));

    private final Script script;

    private DescribeScriptResponse(BuilderImpl builder) {
        super(builder);
        this.script = builder.script;
    }

    /**
     * <p>
     * A set of properties describing the requested script.
     * </p>
     * 
     * @return A set of properties describing the requested script.
     */
    public Script script() {
        return script;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(script());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScriptResponse)) {
            return false;
        }
        DescribeScriptResponse other = (DescribeScriptResponse) obj;
        return Objects.equals(script(), other.script());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScriptResponse").add("Script", script()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Script":
            return Optional.ofNullable(clazz.cast(script()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScriptResponse, T> g) {
        return obj -> g.apply((DescribeScriptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScriptResponse> {
        /**
         * <p>
         * A set of properties describing the requested script.
         * </p>
         * 
         * @param script
         *        A set of properties describing the requested script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder script(Script script);

        /**
         * <p>
         * A set of properties describing the requested script.
         * </p>
         * This is a convenience that creates an instance of the {@link Script.Builder} avoiding the need to create one
         * manually via {@link Script#builder()}.
         *
         * When the {@link Consumer} completes, {@link Script.Builder#build()} is called immediately and its result is
         * passed to {@link #script(Script)}.
         * 
         * @param script
         *        a consumer that will call methods on {@link Script.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #script(Script)
         */
        default Builder script(Consumer<Script.Builder> script) {
            return script(Script.builder().applyMutation(script).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Script script;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScriptResponse model) {
            super(model);
            script(model.script);
        }

        public final Script.Builder getScript() {
            return script != null ? script.toBuilder() : null;
        }

        @Override
        public final Builder script(Script script) {
            this.script = script;
            return this;
        }

        public final void setScript(Script.BuilderImpl script) {
            this.script = script != null ? script.build() : null;
        }

        @Override
        public DescribeScriptResponse build() {
            return new DescribeScriptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
