/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet
 * level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved
 * using the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">GameLift
 * Server SDK</a> call <code>GetInstanceCertificate</code>. All instances in a fleet share the same certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateConfiguration.Builder, CertificateConfiguration> {
    private static final SdkField<String> CERTIFICATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateConfiguration::certificateTypeAsString)).setter(setter(Builder::certificateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateType;

    private CertificateConfiguration(BuilderImpl builder) {
        this.certificateType = builder.certificateType;
    }

    /**
     * <p>
     * Indicates whether a TLS/SSL certificate was generated for a fleet.
     * </p>
     * <p>
     * </p>
     * <p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateType}
     * will return {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateTypeAsString}.
     * </p>
     * 
     * @return Indicates whether a TLS/SSL certificate was generated for a fleet. </p>
     *         <p>
     *         </p>
     *         <p>
     * @see CertificateType
     */
    public CertificateType certificateType() {
        return CertificateType.fromValue(certificateType);
    }

    /**
     * <p>
     * Indicates whether a TLS/SSL certificate was generated for a fleet.
     * </p>
     * <p>
     * </p>
     * <p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateType}
     * will return {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateTypeAsString}.
     * </p>
     * 
     * @return Indicates whether a TLS/SSL certificate was generated for a fleet. </p>
     *         <p>
     *         </p>
     *         <p>
     * @see CertificateType
     */
    public String certificateTypeAsString() {
        return certificateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateConfiguration)) {
            return false;
        }
        CertificateConfiguration other = (CertificateConfiguration) obj;
        return Objects.equals(certificateTypeAsString(), other.certificateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CertificateConfiguration").add("CertificateType", certificateTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateType":
            return Optional.ofNullable(clazz.cast(certificateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateConfiguration, T> g) {
        return obj -> g.apply((CertificateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateConfiguration> {
        /**
         * <p>
         * Indicates whether a TLS/SSL certificate was generated for a fleet.
         * </p>
         * <p>
         * </p>
         * <p>
         * </p>
         * 
         * @param certificateType
         *        Indicates whether a TLS/SSL certificate was generated for a fleet. </p>
         *        <p>
         *        </p>
         *        <p>
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder certificateType(String certificateType);

        /**
         * <p>
         * Indicates whether a TLS/SSL certificate was generated for a fleet.
         * </p>
         * <p>
         * </p>
         * <p>
         * </p>
         * 
         * @param certificateType
         *        Indicates whether a TLS/SSL certificate was generated for a fleet. </p>
         *        <p>
         *        </p>
         *        <p>
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder certificateType(CertificateType certificateType);
    }

    static final class BuilderImpl implements Builder {
        private String certificateType;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateConfiguration model) {
            certificateType(model.certificateType);
        }

        public final String getCertificateTypeAsString() {
            return certificateType;
        }

        @Override
        public final Builder certificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        @Override
        public final Builder certificateType(CertificateType certificateType) {
            this.certificateType(certificateType == null ? null : certificateType.toString());
            return this;
        }

        public final void setCertificateType(String certificateType) {
            this.certificateType = certificateType;
        }

        @Override
        public CertificateConfiguration build() {
            return new CertificateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
