/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType;
import software.amazon.awssdk.services.gamelift.model.MetricName;
import software.amazon.awssdk.services.gamelift.model.PolicyType;
import software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType;
import software.amazon.awssdk.services.gamelift.model.ScalingStatusType;
import software.amazon.awssdk.services.gamelift.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::fleetId)).setter(ScalingPolicy.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::name)).setter(ScalingPolicy.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::statusAsString)).setter(ScalingPolicy.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScalingPolicy.getter(ScalingPolicy::scalingAdjustment)).setter(ScalingPolicy.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<String> SCALING_ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::scalingAdjustmentTypeAsString)).setter(ScalingPolicy.setter(Builder::scalingAdjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustmentType").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::comparisonOperatorAsString)).setter(ScalingPolicy.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ScalingPolicy.getter(ScalingPolicy::threshold)).setter(ScalingPolicy.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScalingPolicy.getter(ScalingPolicy::evaluationPeriods)).setter(ScalingPolicy.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::metricNameAsString)).setter(ScalingPolicy.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::policyTypeAsString)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScalingPolicy.getter(ScalingPolicy::targetConfiguration)).setter(ScalingPolicy.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, NAME_FIELD, STATUS_FIELD, SCALING_ADJUSTMENT_FIELD, SCALING_ADJUSTMENT_TYPE_FIELD, COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD, EVALUATION_PERIODS_FIELD, METRIC_NAME_FIELD, POLICY_TYPE_FIELD, TARGET_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String name;
    private final String status;
    private final Integer scalingAdjustment;
    private final String scalingAdjustmentType;
    private final String comparisonOperator;
    private final Double threshold;
    private final Integer evaluationPeriods;
    private final String metricName;
    private final String policyType;
    private final TargetConfiguration targetConfiguration;

    private ScalingPolicy(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.name = builder.name;
        this.status = builder.status;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.policyType = builder.policyType;
        this.targetConfiguration = builder.targetConfiguration;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String name() {
        return this.name;
    }

    public ScalingStatusType status() {
        return ScalingStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public ScalingAdjustmentType scalingAdjustmentType() {
        return ScalingAdjustmentType.fromValue(this.scalingAdjustmentType);
    }

    public String scalingAdjustmentTypeAsString() {
        return this.scalingAdjustmentType;
    }

    public ComparisonOperatorType comparisonOperator() {
        return ComparisonOperatorType.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public String metricNameAsString() {
        return this.metricName;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.scalingAdjustmentTypeAsString(), other.scalingAdjustmentTypeAsString()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ScalingPolicy").add("FleetId", (Object)this.fleetId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("ScalingAdjustmentType", (Object)this.scalingAdjustmentTypeAsString()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Threshold", (Object)this.threshold()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("MetricName", (Object)this.metricNameAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("TargetConfiguration", (Object)this.targetConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "ScalingAdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustmentTypeAsString()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String name;
        private String status;
        private Integer scalingAdjustment;
        private String scalingAdjustmentType;
        private String comparisonOperator;
        private Double threshold;
        private Integer evaluationPeriods;
        private String metricName;
        private String policyType;
        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.fleetId(model.fleetId);
            this.name(model.name);
            this.status(model.status);
            this.scalingAdjustment(model.scalingAdjustment);
            this.scalingAdjustmentType(model.scalingAdjustmentType);
            this.comparisonOperator(model.comparisonOperator);
            this.threshold(model.threshold);
            this.evaluationPeriods(model.evaluationPeriods);
            this.metricName(model.metricName);
            this.policyType(model.policyType);
            this.targetConfiguration(model.targetConfiguration);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScalingStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final String getScalingAdjustmentTypeAsString() {
            return this.scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType == null ? null : scalingAdjustmentType.toString());
            return this;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        public final String getComparisonOperatorAsString() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricNameAsString() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getPolicyTypeAsString() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder fleetId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ScalingStatusType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder scalingAdjustmentType(String var1);

        public Builder scalingAdjustmentType(ScalingAdjustmentType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperatorType var1);

        public Builder threshold(Double var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }
    }
}

