/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;
import software.amazon.awssdk.services.gamelift.model.FleetAttributesListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetAttributesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetAttributesResponse> {
    private static final SdkField<List<FleetAttributes>> FLEET_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeFleetAttributesResponse.getter(DescribeFleetAttributesResponse::fleetAttributes)).setter(DescribeFleetAttributesResponse.setter(Builder::fleetAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFleetAttributesResponse.getter(DescribeFleetAttributesResponse::nextToken)).setter(DescribeFleetAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FleetAttributes> fleetAttributes;
    private final String nextToken;

    private DescribeFleetAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAttributes = builder.fleetAttributes;
        this.nextToken = builder.nextToken;
    }

    public List<FleetAttributes> fleetAttributes() {
        return this.fleetAttributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAttributesResponse)) {
            return false;
        }
        DescribeFleetAttributesResponse other = (DescribeFleetAttributesResponse)((Object)obj);
        return Objects.equals(this.fleetAttributes(), other.fleetAttributes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetAttributesResponse").add("FleetAttributes", this.fleetAttributes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetAttributes": {
                return Optional.ofNullable(clazz.cast(this.fleetAttributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAttributesResponse, T> g) {
        return obj -> g.apply((DescribeFleetAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetAttributes> fleetAttributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAttributesResponse model) {
            super(model);
            this.fleetAttributes(model.fleetAttributes);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetAttributes.Builder> getFleetAttributes() {
            return this.fleetAttributes != null ? (Collection)this.fleetAttributes.stream().map(FleetAttributes::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetAttributes(Collection<FleetAttributes> fleetAttributes) {
            this.fleetAttributes = FleetAttributesListCopier.copy(fleetAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAttributes(FleetAttributes ... fleetAttributes) {
            this.fleetAttributes(Arrays.asList(fleetAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAttributes(Consumer<FleetAttributes.Builder> ... fleetAttributes) {
            this.fleetAttributes(Stream.of(fleetAttributes).map(c -> (FleetAttributes)((FleetAttributes.Builder)FleetAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleetAttributes(Collection<FleetAttributes.BuilderImpl> fleetAttributes) {
            this.fleetAttributes = FleetAttributesListCopier.copyFromBuilder(fleetAttributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetAttributesResponse build() {
            return new DescribeFleetAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetAttributesResponse> {
        public Builder fleetAttributes(Collection<FleetAttributes> var1);

        public Builder fleetAttributes(FleetAttributes ... var1);

        public Builder fleetAttributes(Consumer<FleetAttributes.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

