/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuntimeConfigurationMarshaller {
    private static final MarshallingInfo<List> SERVERPROCESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerProcesses").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXCONCURRENTGAMESESSIONACTIVATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrentGameSessionActivations").isBinary(false).build();
    private static final MarshallingInfo<Integer> GAMESESSIONACTIVATIONTIMEOUTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionActivationTimeoutSeconds").isBinary(false).build();
    private static final RuntimeConfigurationMarshaller INSTANCE = new RuntimeConfigurationMarshaller();

    private RuntimeConfigurationMarshaller() {
    }

    public static RuntimeConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RuntimeConfiguration runtimeConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)runtimeConfiguration, (String)"runtimeConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(runtimeConfiguration.serverProcesses(), SERVERPROCESSES_BINDING);
            protocolMarshaller.marshall((Object)runtimeConfiguration.maxConcurrentGameSessionActivations(), MAXCONCURRENTGAMESESSIONACTIVATIONS_BINDING);
            protocolMarshaller.marshall((Object)runtimeConfiguration.gameSessionActivationTimeoutSeconds(), GAMESESSIONACTIVATIONTIMEOUTSECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

