/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.services.gamelift.transform.AttributeValueUnmarshaller;

public class PlayerUnmarshaller
implements Unmarshaller<Player, JsonUnmarshallerContext> {
    private static final PlayerUnmarshaller INSTANCE = new PlayerUnmarshaller();

    public Player unmarshall(JsonUnmarshallerContext context) throws Exception {
        Player.Builder playerBuilder = Player.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("PlayerId", targetDepth)) {
                    context.nextToken();
                    playerBuilder.playerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PlayerAttributes", targetDepth)) {
                    context.nextToken();
                    playerBuilder.playerAttributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Team", targetDepth)) {
                    context.nextToken();
                    playerBuilder.team((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LatencyInMs", targetDepth)) {
                    context.nextToken();
                    playerBuilder.latencyInMs(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Player)playerBuilder.build();
    }

    public static PlayerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

