/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.VpcPeeringAuthorizationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcPeeringAuthorization
implements StructuredPojo,
ToCopyableBuilder<Builder, VpcPeeringAuthorization> {
    private final String gameLiftAwsAccountId;
    private final String peerVpcAwsAccountId;
    private final String peerVpcId;
    private final Instant creationTime;
    private final Instant expirationTime;

    private VpcPeeringAuthorization(BuilderImpl builder) {
        this.gameLiftAwsAccountId = builder.gameLiftAwsAccountId;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
    }

    public String gameLiftAwsAccountId() {
        return this.gameLiftAwsAccountId;
    }

    public String peerVpcAwsAccountId() {
        return this.peerVpcAwsAccountId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant expirationTime() {
        return this.expirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameLiftAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringAuthorization)) {
            return false;
        }
        VpcPeeringAuthorization other = (VpcPeeringAuthorization)obj;
        return Objects.equals(this.gameLiftAwsAccountId(), other.gameLiftAwsAccountId()) && Objects.equals(this.peerVpcAwsAccountId(), other.peerVpcAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.expirationTime(), other.expirationTime());
    }

    public String toString() {
        return ToString.builder((String)"VpcPeeringAuthorization").add("GameLiftAwsAccountId", (Object)this.gameLiftAwsAccountId()).add("PeerVpcAwsAccountId", (Object)this.peerVpcAwsAccountId()).add("PeerVpcId", (Object)this.peerVpcId()).add("CreationTime", (Object)this.creationTime()).add("ExpirationTime", (Object)this.expirationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameLiftAwsAccountId": {
                return Optional.of(clazz.cast(this.gameLiftAwsAccountId()));
            }
            case "PeerVpcAwsAccountId": {
                return Optional.of(clazz.cast(this.peerVpcAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.of(clazz.cast(this.peerVpcId()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "ExpirationTime": {
                return Optional.of(clazz.cast(this.expirationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcPeeringAuthorizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameLiftAwsAccountId;
        private String peerVpcAwsAccountId;
        private String peerVpcId;
        private Instant creationTime;
        private Instant expirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringAuthorization model) {
            this.gameLiftAwsAccountId(model.gameLiftAwsAccountId);
            this.peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            this.peerVpcId(model.peerVpcId);
            this.creationTime(model.creationTime);
            this.expirationTime(model.expirationTime);
        }

        public final String getGameLiftAwsAccountId() {
            return this.gameLiftAwsAccountId;
        }

        @Override
        public final Builder gameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
            return this;
        }

        public final void setGameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
        }

        public final String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public VpcPeeringAuthorization build() {
            return new VpcPeeringAuthorization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringAuthorization> {
        public Builder gameLiftAwsAccountId(String var1);

        public Builder peerVpcAwsAccountId(String var1);

        public Builder peerVpcId(String var1);

        public Builder creationTime(Instant var1);

        public Builder expirationTime(Instant var1);
    }
}

