/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRuntimeConfigurationRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateRuntimeConfigurationRequest> {
    private final String fleetId;
    private final RuntimeConfiguration runtimeConfiguration;

    private UpdateRuntimeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.runtimeConfiguration = builder.runtimeConfiguration;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public RuntimeConfiguration runtimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuntimeConfigurationRequest)) {
            return false;
        }
        UpdateRuntimeConfigurationRequest other = (UpdateRuntimeConfigurationRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.runtimeConfiguration(), other.runtimeConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRuntimeConfigurationRequest").add("FleetId", (Object)this.fleetId()).add("RuntimeConfiguration", (Object)this.runtimeConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "RuntimeConfiguration": {
                return Optional.of(clazz.cast(this.runtimeConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private RuntimeConfiguration runtimeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuntimeConfigurationRequest model) {
            this.fleetId(model.fleetId);
            this.runtimeConfiguration(model.runtimeConfiguration);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return this.runtimeConfiguration != null ? this.runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuntimeConfigurationRequest build() {
            return new UpdateRuntimeConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, UpdateRuntimeConfigurationRequest> {
        public Builder fleetId(String var1);

        public Builder runtimeConfiguration(RuntimeConfiguration var1);

        default public Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return this.runtimeConfiguration((RuntimeConfiguration)((RuntimeConfiguration.Builder)RuntimeConfiguration.builder().apply(runtimeConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

