/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartGameSessionPlacementRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StartGameSessionPlacementRequest> {
    private final String placementId;
    private final String gameSessionQueueName;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final List<PlayerLatency> playerLatencies;
    private final List<DesiredPlayerSession> desiredPlayerSessions;
    private final String gameSessionData;

    private StartGameSessionPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.playerLatencies = builder.playerLatencies;
        this.desiredPlayerSessions = builder.desiredPlayerSessions;
        this.gameSessionData = builder.gameSessionData;
    }

    public String placementId() {
        return this.placementId;
    }

    public String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String gameSessionName() {
        return this.gameSessionName;
    }

    public List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public List<DesiredPlayerSession> desiredPlayerSessions() {
        return this.desiredPlayerSessions;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerLatencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredPlayerSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGameSessionPlacementRequest)) {
            return false;
        }
        StartGameSessionPlacementRequest other = (StartGameSessionPlacementRequest)((Object)obj);
        return Objects.equals(this.placementId(), other.placementId()) && Objects.equals(this.gameSessionQueueName(), other.gameSessionQueueName()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.gameSessionName(), other.gameSessionName()) && Objects.equals(this.playerLatencies(), other.playerLatencies()) && Objects.equals(this.desiredPlayerSessions(), other.desiredPlayerSessions()) && Objects.equals(this.gameSessionData(), other.gameSessionData());
    }

    public String toString() {
        return ToString.builder((String)"StartGameSessionPlacementRequest").add("PlacementId", (Object)this.placementId()).add("GameSessionQueueName", (Object)this.gameSessionQueueName()).add("GameProperties", this.gameProperties()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("GameSessionName", (Object)this.gameSessionName()).add("PlayerLatencies", this.playerLatencies()).add("DesiredPlayerSessions", this.desiredPlayerSessions()).add("GameSessionData", (Object)this.gameSessionData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementId": {
                return Optional.of(clazz.cast(this.placementId()));
            }
            case "GameSessionQueueName": {
                return Optional.of(clazz.cast(this.gameSessionQueueName()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "GameSessionName": {
                return Optional.of(clazz.cast(this.gameSessionName()));
            }
            case "PlayerLatencies": {
                return Optional.of(clazz.cast(this.playerLatencies()));
            }
            case "DesiredPlayerSessions": {
                return Optional.of(clazz.cast(this.desiredPlayerSessions()));
            }
            case "GameSessionData": {
                return Optional.of(clazz.cast(this.gameSessionData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private List<GameProperty> gameProperties;
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private List<PlayerLatency> playerLatencies;
        private List<DesiredPlayerSession> desiredPlayerSessions;
        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGameSessionPlacementRequest model) {
            this.placementId(model.placementId);
            this.gameSessionQueueName(model.gameSessionQueueName);
            this.gameProperties(model.gameProperties);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.gameSessionName(model.gameSessionName);
            this.playerLatencies(model.playerLatencies);
            this.desiredPlayerSessions(model.desiredPlayerSessions);
            this.gameSessionData(model.gameSessionData);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        public final Collection<PlayerLatency.Builder> getPlayerLatencies() {
            return this.playerLatencies != null ? (Collection)this.playerLatencies.stream().map(PlayerLatency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        public final Collection<DesiredPlayerSession.Builder> getDesiredPlayerSessions() {
            return this.desiredPlayerSessions != null ? (Collection)this.desiredPlayerSessions.stream().map(DesiredPlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder desiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copy(desiredPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(DesiredPlayerSession ... desiredPlayerSessions) {
            this.desiredPlayerSessions(Arrays.asList(desiredPlayerSessions));
            return this;
        }

        public final void setDesiredPlayerSessions(Collection<DesiredPlayerSession.BuilderImpl> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copyFromBuilder(desiredPlayerSessions);
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartGameSessionPlacementRequest build() {
            return new StartGameSessionPlacementRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, StartGameSessionPlacementRequest> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder desiredPlayerSessions(Collection<DesiredPlayerSession> var1);

        public Builder desiredPlayerSessions(DesiredPlayerSession ... var1);

        public Builder gameSessionData(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

