/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.ResourceCreationLimitPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceCreationLimitPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceCreationLimitPolicy> {
    private final Integer newGameSessionsPerCreator;
    private final Integer policyPeriodInMinutes;

    private ResourceCreationLimitPolicy(BuilderImpl builder) {
        this.newGameSessionsPerCreator = builder.newGameSessionsPerCreator;
        this.policyPeriodInMinutes = builder.policyPeriodInMinutes;
    }

    public Integer newGameSessionsPerCreator() {
        return this.newGameSessionsPerCreator;
    }

    public Integer policyPeriodInMinutes() {
        return this.policyPeriodInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionsPerCreator());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyPeriodInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCreationLimitPolicy)) {
            return false;
        }
        ResourceCreationLimitPolicy other = (ResourceCreationLimitPolicy)obj;
        return Objects.equals(this.newGameSessionsPerCreator(), other.newGameSessionsPerCreator()) && Objects.equals(this.policyPeriodInMinutes(), other.policyPeriodInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"ResourceCreationLimitPolicy").add("NewGameSessionsPerCreator", (Object)this.newGameSessionsPerCreator()).add("PolicyPeriodInMinutes", (Object)this.policyPeriodInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NewGameSessionsPerCreator": {
                return Optional.of(clazz.cast(this.newGameSessionsPerCreator()));
            }
            case "PolicyPeriodInMinutes": {
                return Optional.of(clazz.cast(this.policyPeriodInMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceCreationLimitPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer newGameSessionsPerCreator;
        private Integer policyPeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCreationLimitPolicy model) {
            this.newGameSessionsPerCreator(model.newGameSessionsPerCreator);
            this.policyPeriodInMinutes(model.policyPeriodInMinutes);
        }

        public final Integer getNewGameSessionsPerCreator() {
            return this.newGameSessionsPerCreator;
        }

        @Override
        public final Builder newGameSessionsPerCreator(Integer newGameSessionsPerCreator) {
            this.newGameSessionsPerCreator = newGameSessionsPerCreator;
            return this;
        }

        public final void setNewGameSessionsPerCreator(Integer newGameSessionsPerCreator) {
            this.newGameSessionsPerCreator = newGameSessionsPerCreator;
        }

        public final Integer getPolicyPeriodInMinutes() {
            return this.policyPeriodInMinutes;
        }

        @Override
        public final Builder policyPeriodInMinutes(Integer policyPeriodInMinutes) {
            this.policyPeriodInMinutes = policyPeriodInMinutes;
            return this;
        }

        public final void setPolicyPeriodInMinutes(Integer policyPeriodInMinutes) {
            this.policyPeriodInMinutes = policyPeriodInMinutes;
        }

        public ResourceCreationLimitPolicy build() {
            return new ResourceCreationLimitPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceCreationLimitPolicy> {
        public Builder newGameSessionsPerCreator(Integer var1);

        public Builder policyPeriodInMinutes(Integer var1);
    }
}

