/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.gamelift.model.FleetIdListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFleetsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListFleetsResponse> {
    private final List<String> fleetIds;
    private final String nextToken;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetIds = builder.fleetIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> fleetIds() {
        return this.fleetIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse)((Object)obj);
        return Objects.equals(this.fleetIds(), other.fleetIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFleetsResponse").add("FleetIds", this.fleetIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetIds": {
                return Optional.of(clazz.cast(this.fleetIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<String> fleetIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            this.fleetIds(model.fleetIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFleetIds() {
            return this.fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, ListFleetsResponse> {
        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

