/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;
import software.amazon.awssdk.services.gamelift.model.FleetUtilizationListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetUtilizationResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
    private final List<FleetUtilization> fleetUtilization;
    private final String nextToken;

    private DescribeFleetUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.fleetUtilization = builder.fleetUtilization;
        this.nextToken = builder.nextToken;
    }

    public List<FleetUtilization> fleetUtilization() {
        return this.fleetUtilization;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationResponse)) {
            return false;
        }
        DescribeFleetUtilizationResponse other = (DescribeFleetUtilizationResponse)((Object)obj);
        return Objects.equals(this.fleetUtilization(), other.fleetUtilization()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetUtilizationResponse").add("FleetUtilization", this.fleetUtilization()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetUtilization": {
                return Optional.of(clazz.cast(this.fleetUtilization()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetUtilization> fleetUtilization;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationResponse model) {
            this.fleetUtilization(model.fleetUtilization);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetUtilization.Builder> getFleetUtilization() {
            return this.fleetUtilization != null ? (Collection)this.fleetUtilization.stream().map(FleetUtilization::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copy(fleetUtilization);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(FleetUtilization ... fleetUtilization) {
            this.fleetUtilization(Arrays.asList(fleetUtilization));
            return this;
        }

        public final void setFleetUtilization(Collection<FleetUtilization.BuilderImpl> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copyFromBuilder(fleetUtilization);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetUtilizationResponse build() {
            return new DescribeFleetUtilizationResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
        public Builder fleetUtilization(Collection<FleetUtilization> var1);

        public Builder fleetUtilization(FleetUtilization ... var1);

        public Builder nextToken(String var1);
    }
}

