/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicket;

@SdkInternalApi
public class MatchmakingTicketMarshaller {
    private static final MarshallingInfo<String> TICKETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TicketId").build();
    private static final MarshallingInfo<String> CONFIGURATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusReason").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<List> PLAYERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Players").build();
    private static final MarshallingInfo<StructuredPojo> GAMESESSIONCONNECTIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionConnectionInfo").build();
    private static final MarshallingInfo<Integer> ESTIMATEDWAITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EstimatedWaitTime").build();
    private static final MatchmakingTicketMarshaller INSTANCE = new MatchmakingTicketMarshaller();

    public static MatchmakingTicketMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MatchmakingTicket matchmakingTicket, ProtocolMarshaller protocolMarshaller) {
        if (matchmakingTicket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)matchmakingTicket.ticketId(), TICKETID_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.configurationName(), CONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(matchmakingTicket.players(), PLAYERS_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.gameSessionConnectionInfo(), GAMESESSIONCONNECTIONINFO_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.estimatedWaitTime(), ESTIMATEDWAITTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

