/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerDataMapCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlayerSessionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionsRequest> {
    private final String gameSessionId;
    private final List<String> playerIds;
    private final Map<String, String> playerDataMap;

    private CreatePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerIds = builder.playerIds;
        this.playerDataMap = builder.playerDataMap;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public List<String> playerIds() {
        return this.playerIds;
    }

    public Map<String, String> playerDataMap() {
        return this.playerDataMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerDataMap());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsRequest)) {
            return false;
        }
        CreatePlayerSessionsRequest other = (CreatePlayerSessionsRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerIds(), other.playerIds()) && Objects.equals(this.playerDataMap(), other.playerDataMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.playerIds() != null) {
            sb.append("PlayerIds: ").append(this.playerIds()).append(",");
        }
        if (this.playerDataMap() != null) {
            sb.append("PlayerDataMap: ").append(this.playerDataMap()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "PlayerIds": {
                return Optional.of(clazz.cast(this.playerIds()));
            }
            case "PlayerDataMap": {
                return Optional.of(clazz.cast(this.playerDataMap()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private List<String> playerIds;
        private Map<String, String> playerDataMap;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsRequest model) {
            this.gameSessionId(model.gameSessionId);
            this.playerIds(model.playerIds);
            this.playerDataMap(model.playerDataMap);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Collection<String> getPlayerIds() {
            return this.playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String ... playerIds) {
            this.playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
        }

        public final Map<String, String> getPlayerDataMap() {
            return this.playerDataMap;
        }

        @Override
        public final Builder playerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
            return this;
        }

        public final void setPlayerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionsRequest build() {
            return new CreatePlayerSessionsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, CreatePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerIds(Collection<String> var1);

        public Builder playerIds(String ... var1);

        public Builder playerDataMap(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

