/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;

@SdkInternalApi
public class PlayerSessionMarshaller {
    private static final MarshallingInfo<String> PLAYERSESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerSessionId").build();
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").build();
    private static final MarshallingInfo<String> GAMESESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionId").build();
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Instant> TERMINATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationTime").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final MarshallingInfo<String> PLAYERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerData").build();
    private static final PlayerSessionMarshaller INSTANCE = new PlayerSessionMarshaller();

    public static PlayerSessionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlayerSession playerSession, ProtocolMarshaller protocolMarshaller) {
        if (playerSession == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)playerSession.playerSessionId(), PLAYERSESSIONID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.gameSessionId(), GAMESESSIONID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)playerSession.terminationTime(), TERMINATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)playerSession.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)playerSession.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)playerSession.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)playerSession.playerData(), PLAYERDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

