/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.InstanceCredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCredentials
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceCredentials> {
    private final String userName;
    private final String secret;

    private InstanceCredentials(BuilderImpl builder) {
        this.userName = builder.userName;
        this.secret = builder.secret;
    }

    public String userName() {
        return this.userName;
    }

    public String secret() {
        return this.secret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCredentials)) {
            return false;
        }
        InstanceCredentials other = (InstanceCredentials)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.secret(), other.secret());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.secret() != null) {
            sb.append("Secret: ").append(this.secret()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "Secret": {
                return Optional.of(clazz.cast(this.secret()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String secret;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCredentials model) {
            this.userName(model.userName);
            this.secret(model.secret);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSecret() {
            return this.secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        public InstanceCredentials build() {
            return new InstanceCredentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCredentials> {
        public Builder userName(String var1);

        public Builder secret(String var1);
    }
}

