/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.services.gamelift.transform.GameSessionPlacementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionPlacement
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionPlacement> {
    private final String placementId;
    private final String gameSessionQueueName;
    private final String status;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final String gameSessionId;
    private final String gameSessionArn;
    private final String gameSessionRegion;
    private final List<PlayerLatency> playerLatencies;
    private final Instant startTime;
    private final Instant endTime;
    private final String ipAddress;
    private final Integer port;
    private final List<PlacedPlayerSession> placedPlayerSessions;
    private final String gameSessionData;

    private GameSessionPlacement(BuilderImpl builder) {
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.status = builder.status;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.gameSessionId = builder.gameSessionId;
        this.gameSessionArn = builder.gameSessionArn;
        this.gameSessionRegion = builder.gameSessionRegion;
        this.playerLatencies = builder.playerLatencies;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.placedPlayerSessions = builder.placedPlayerSessions;
        this.gameSessionData = builder.gameSessionData;
    }

    public String placementId() {
        return this.placementId;
    }

    public String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public GameSessionPlacementState status() {
        return GameSessionPlacementState.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String gameSessionName() {
        return this.gameSessionName;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String gameSessionArn() {
        return this.gameSessionArn;
    }

    public String gameSessionRegion() {
        return this.gameSessionRegion;
    }

    public List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public List<PlacedPlayerSession> placedPlayerSessions() {
        return this.placedPlayerSessions;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerLatencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.placedPlayerSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionPlacement)) {
            return false;
        }
        GameSessionPlacement other = (GameSessionPlacement)obj;
        return Objects.equals(this.placementId(), other.placementId()) && Objects.equals(this.gameSessionQueueName(), other.gameSessionQueueName()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.gameSessionName(), other.gameSessionName()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.gameSessionArn(), other.gameSessionArn()) && Objects.equals(this.gameSessionRegion(), other.gameSessionRegion()) && Objects.equals(this.playerLatencies(), other.playerLatencies()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.placedPlayerSessions(), other.placedPlayerSessions()) && Objects.equals(this.gameSessionData(), other.gameSessionData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.placementId() != null) {
            sb.append("PlacementId: ").append(this.placementId()).append(",");
        }
        if (this.gameSessionQueueName() != null) {
            sb.append("GameSessionQueueName: ").append(this.gameSessionQueueName()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.gameSessionName() != null) {
            sb.append("GameSessionName: ").append(this.gameSessionName()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.gameSessionArn() != null) {
            sb.append("GameSessionArn: ").append(this.gameSessionArn()).append(",");
        }
        if (this.gameSessionRegion() != null) {
            sb.append("GameSessionRegion: ").append(this.gameSessionRegion()).append(",");
        }
        if (this.playerLatencies() != null) {
            sb.append("PlayerLatencies: ").append(this.playerLatencies()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.placedPlayerSessions() != null) {
            sb.append("PlacedPlayerSessions: ").append(this.placedPlayerSessions()).append(",");
        }
        if (this.gameSessionData() != null) {
            sb.append("GameSessionData: ").append(this.gameSessionData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementId": {
                return Optional.of(clazz.cast(this.placementId()));
            }
            case "GameSessionQueueName": {
                return Optional.of(clazz.cast(this.gameSessionQueueName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "GameSessionName": {
                return Optional.of(clazz.cast(this.gameSessionName()));
            }
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "GameSessionArn": {
                return Optional.of(clazz.cast(this.gameSessionArn()));
            }
            case "GameSessionRegion": {
                return Optional.of(clazz.cast(this.gameSessionRegion()));
            }
            case "PlayerLatencies": {
                return Optional.of(clazz.cast(this.playerLatencies()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "PlacedPlayerSessions": {
                return Optional.of(clazz.cast(this.placedPlayerSessions()));
            }
            case "GameSessionData": {
                return Optional.of(clazz.cast(this.gameSessionData()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionPlacementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private String status;
        private List<GameProperty> gameProperties;
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private String gameSessionId;
        private String gameSessionArn;
        private String gameSessionRegion;
        private List<PlayerLatency> playerLatencies;
        private Instant startTime;
        private Instant endTime;
        private String ipAddress;
        private Integer port;
        private List<PlacedPlayerSession> placedPlayerSessions;
        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionPlacement model) {
            this.placementId(model.placementId);
            this.gameSessionQueueName(model.gameSessionQueueName);
            this.status(model.status);
            this.gameProperties(model.gameProperties);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.gameSessionName(model.gameSessionName);
            this.gameSessionId(model.gameSessionId);
            this.gameSessionArn(model.gameSessionArn);
            this.gameSessionRegion(model.gameSessionRegion);
            this.playerLatencies(model.playerLatencies);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.placedPlayerSessions(model.placedPlayerSessions);
            this.gameSessionData(model.gameSessionData);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionPlacementState status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        public final String getGameSessionRegion() {
            return this.gameSessionRegion;
        }

        @Override
        public final Builder gameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
            return this;
        }

        public final void setGameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
        }

        public final Collection<PlayerLatency.Builder> getPlayerLatencies() {
            return this.playerLatencies != null ? (Collection)this.playerLatencies.stream().map(PlayerLatency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Collection<PlacedPlayerSession.Builder> getPlacedPlayerSessions() {
            return this.placedPlayerSessions != null ? (Collection)this.placedPlayerSessions.stream().map(PlacedPlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placedPlayerSessions(Collection<PlacedPlayerSession> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copy(placedPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placedPlayerSessions(PlacedPlayerSession ... placedPlayerSessions) {
            this.placedPlayerSessions(Arrays.asList(placedPlayerSessions));
            return this;
        }

        public final void setPlacedPlayerSessions(Collection<PlacedPlayerSession.BuilderImpl> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copyFromBuilder(placedPlayerSessions);
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        public GameSessionPlacement build() {
            return new GameSessionPlacement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionPlacement> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder status(String var1);

        public Builder status(GameSessionPlacementState var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder gameSessionId(String var1);

        public Builder gameSessionArn(String var1);

        public Builder gameSessionRegion(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder placedPlayerSessions(Collection<PlacedPlayerSession> var1);

        public Builder placedPlayerSessions(PlacedPlayerSession ... var1);

        public Builder gameSessionData(String var1);
    }
}

