/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.MatchedPlayerSession;
import software.amazon.awssdk.services.gamelift.model.MatchedPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.transform.GameSessionConnectionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionConnectionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionConnectionInfo> {
    private final String gameSessionArn;
    private final String ipAddress;
    private final Integer port;
    private final List<MatchedPlayerSession> matchedPlayerSessions;

    private GameSessionConnectionInfo(BuilderImpl builder) {
        this.gameSessionArn = builder.gameSessionArn;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.matchedPlayerSessions = builder.matchedPlayerSessions;
    }

    public String gameSessionArn() {
        return this.gameSessionArn;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public List<MatchedPlayerSession> matchedPlayerSessions() {
        return this.matchedPlayerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedPlayerSessions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionConnectionInfo)) {
            return false;
        }
        GameSessionConnectionInfo other = (GameSessionConnectionInfo)obj;
        return Objects.equals(this.gameSessionArn(), other.gameSessionArn()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.matchedPlayerSessions(), other.matchedPlayerSessions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionArn() != null) {
            sb.append("GameSessionArn: ").append(this.gameSessionArn()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.matchedPlayerSessions() != null) {
            sb.append("MatchedPlayerSessions: ").append(this.matchedPlayerSessions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionArn": {
                return Optional.of(clazz.cast(this.gameSessionArn()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "MatchedPlayerSessions": {
                return Optional.of(clazz.cast(this.matchedPlayerSessions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionConnectionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionArn;
        private String ipAddress;
        private Integer port;
        private List<MatchedPlayerSession> matchedPlayerSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionConnectionInfo model) {
            this.gameSessionArn(model.gameSessionArn);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.matchedPlayerSessions(model.matchedPlayerSessions);
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Collection<MatchedPlayerSession.Builder> getMatchedPlayerSessions() {
            return this.matchedPlayerSessions != null ? (Collection)this.matchedPlayerSessions.stream().map(MatchedPlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matchedPlayerSessions(Collection<MatchedPlayerSession> matchedPlayerSessions) {
            this.matchedPlayerSessions = MatchedPlayerSessionListCopier.copy(matchedPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedPlayerSessions(MatchedPlayerSession ... matchedPlayerSessions) {
            this.matchedPlayerSessions(Arrays.asList(matchedPlayerSessions));
            return this;
        }

        public final void setMatchedPlayerSessions(Collection<MatchedPlayerSession.BuilderImpl> matchedPlayerSessions) {
            this.matchedPlayerSessions = MatchedPlayerSessionListCopier.copyFromBuilder(matchedPlayerSessions);
        }

        public GameSessionConnectionInfo build() {
            return new GameSessionConnectionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionConnectionInfo> {
        public Builder gameSessionArn(String var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder matchedPlayerSessions(Collection<MatchedPlayerSession> var1);

        public Builder matchedPlayerSessions(MatchedPlayerSession ... var1);
    }
}

