/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetPortSettingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
    private final List<IpPermission> inboundPermissions;

    private DescribeFleetPortSettingsResponse(BuilderImpl builder) {
        this.inboundPermissions = builder.inboundPermissions;
    }

    public List<IpPermission> inboundPermissions() {
        return this.inboundPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetPortSettingsResponse)) {
            return false;
        }
        DescribeFleetPortSettingsResponse other = (DescribeFleetPortSettingsResponse)((Object)obj);
        return Objects.equals(this.inboundPermissions(), other.inboundPermissions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.inboundPermissions() != null) {
            sb.append("InboundPermissions: ").append(this.inboundPermissions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboundPermissions": {
                return Optional.of(clazz.cast(this.inboundPermissions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<IpPermission> inboundPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetPortSettingsResponse model) {
            this.inboundPermissions(model.inboundPermissions);
        }

        public final Collection<IpPermission.Builder> getInboundPermissions() {
            return this.inboundPermissions != null ? (Collection)this.inboundPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissions(Collection<IpPermission> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copy(inboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(IpPermission ... inboundPermissions) {
            this.inboundPermissions(Arrays.asList(inboundPermissions));
            return this;
        }

        public final void setInboundPermissions(Collection<IpPermission.BuilderImpl> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copyFromBuilder(inboundPermissions);
        }

        public DescribeFleetPortSettingsResponse build() {
            return new DescribeFleetPortSettingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
        public Builder inboundPermissions(Collection<IpPermission> var1);

        public Builder inboundPermissions(IpPermission ... var1);
    }
}

