/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateBuildRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateBuildRequest> {
    private final String buildId;
    private final String name;
    private final String version;

    private UpdateBuildRequest(BuilderImpl builder) {
        this.buildId = builder.buildId;
        this.name = builder.name;
        this.version = builder.version;
    }

    public String buildId() {
        return this.buildId;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.buildId() == null ? 0 : this.buildId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBuildRequest)) {
            return false;
        }
        UpdateBuildRequest other = (UpdateBuildRequest)((Object)obj);
        if (other.buildId() == null ^ this.buildId() == null) {
            return false;
        }
        if (other.buildId() != null && !other.buildId().equals(this.buildId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.buildId() != null) {
            sb.append("BuildId: ").append(this.buildId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BuildId": {
                return Optional.of(clazz.cast(this.buildId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String buildId;
        private String name;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBuildRequest model) {
            this.buildId(model.buildId);
            this.name(model.name);
            this.version(model.version);
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public UpdateBuildRequest build() {
            return new UpdateBuildRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateBuildRequest> {
        public Builder buildId(String var1);

        public Builder name(String var1);

        public Builder version(String var1);
    }
}

