/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType;
import software.amazon.awssdk.services.gamelift.model.MetricName;
import software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutScalingPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutScalingPolicyRequest> {
    private final String name;
    private final String fleetId;
    private final Integer scalingAdjustment;
    private final String scalingAdjustmentType;
    private final Double threshold;
    private final String comparisonOperator;
    private final Integer evaluationPeriods;
    private final String metricName;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
    }

    public String name() {
        return this.name;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public ScalingAdjustmentType scalingAdjustmentType() {
        return ScalingAdjustmentType.fromValue(this.scalingAdjustmentType);
    }

    public String scalingAdjustmentTypeString() {
        return this.scalingAdjustmentType;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ComparisonOperatorType comparisonOperator() {
        return ComparisonOperatorType.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public String metricNameString() {
        return this.metricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustment() == null ? 0 : this.scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustmentTypeString() == null ? 0 : this.scalingAdjustmentTypeString().hashCode());
        hashCode = 31 * hashCode + (this.threshold() == null ? 0 : this.threshold().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperatorString() == null ? 0 : this.comparisonOperatorString().hashCode());
        hashCode = 31 * hashCode + (this.evaluationPeriods() == null ? 0 : this.evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.metricNameString() == null ? 0 : this.metricNameString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.scalingAdjustmentTypeString() == null ^ this.scalingAdjustmentTypeString() == null) {
            return false;
        }
        if (other.scalingAdjustmentTypeString() != null && !other.scalingAdjustmentTypeString().equals(this.scalingAdjustmentTypeString())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.comparisonOperatorString() == null ^ this.comparisonOperatorString() == null) {
            return false;
        }
        if (other.comparisonOperatorString() != null && !other.comparisonOperatorString().equals(this.comparisonOperatorString())) {
            return false;
        }
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.metricNameString() == null ^ this.metricNameString() == null) {
            return false;
        }
        return other.metricNameString() == null || other.metricNameString().equals(this.metricNameString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.scalingAdjustment()).append(",");
        }
        if (this.scalingAdjustmentTypeString() != null) {
            sb.append("ScalingAdjustmentType: ").append(this.scalingAdjustmentTypeString()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperatorString()).append(",");
        }
        if (this.evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.evaluationPeriods()).append(",");
        }
        if (this.metricNameString() != null) {
            sb.append("MetricName: ").append(this.metricNameString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "ScalingAdjustment": {
                return Optional.of(clazz.cast(this.scalingAdjustment()));
            }
            case "ScalingAdjustmentType": {
                return Optional.of(clazz.cast(this.scalingAdjustmentTypeString()));
            }
            case "Threshold": {
                return Optional.of(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
            case "EvaluationPeriods": {
                return Optional.of(clazz.cast(this.evaluationPeriods()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricNameString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String fleetId;
        private Integer scalingAdjustment;
        private String scalingAdjustmentType;
        private Double threshold;
        private String comparisonOperator;
        private Integer evaluationPeriods;
        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            this.name(model.name);
            this.fleetId(model.fleetId);
            this.scalingAdjustment(model.scalingAdjustment);
            this.scalingAdjustmentType(model.scalingAdjustmentType);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.evaluationPeriods(model.evaluationPeriods);
            this.metricName(model.metricName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final String getScalingAdjustmentType() {
            return this.scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType.toString());
            return this;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutScalingPolicyRequest> {
        public Builder name(String var1);

        public Builder fleetId(String var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder scalingAdjustmentType(String var1);

        public Builder scalingAdjustmentType(ScalingAdjustmentType var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperatorType var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);
    }
}

