/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.transform.GameSessionDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionDetail> {
    private final GameSession gameSession;
    private final String protectionPolicy;

    private GameSessionDetail(BuilderImpl builder) {
        this.gameSession = builder.gameSession;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public GameSession gameSession() {
        return this.gameSession;
    }

    public ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(this.protectionPolicy);
    }

    public String protectionPolicyString() {
        return this.protectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSession() == null ? 0 : this.gameSession().hashCode());
        hashCode = 31 * hashCode + (this.protectionPolicyString() == null ? 0 : this.protectionPolicyString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionDetail)) {
            return false;
        }
        GameSessionDetail other = (GameSessionDetail)obj;
        if (other.gameSession() == null ^ this.gameSession() == null) {
            return false;
        }
        if (other.gameSession() != null && !other.gameSession().equals(this.gameSession())) {
            return false;
        }
        if (other.protectionPolicyString() == null ^ this.protectionPolicyString() == null) {
            return false;
        }
        return other.protectionPolicyString() == null || other.protectionPolicyString().equals(this.protectionPolicyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSession() != null) {
            sb.append("GameSession: ").append(this.gameSession()).append(",");
        }
        if (this.protectionPolicyString() != null) {
            sb.append("ProtectionPolicy: ").append(this.protectionPolicyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSession": {
                return Optional.of(clazz.cast(this.gameSession()));
            }
            case "ProtectionPolicy": {
                return Optional.of(clazz.cast(this.protectionPolicyString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private GameSession gameSession;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionDetail model) {
            this.gameSession(model.gameSession);
            this.protectionPolicy(model.protectionPolicy);
        }

        public final GameSession.Builder getGameSession() {
            return this.gameSession != null ? this.gameSession.toBuilder() : null;
        }

        @Override
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        public final void setGameSession(GameSession.BuilderImpl gameSession) {
            this.gameSession = gameSession != null ? gameSession.build() : null;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        public GameSessionDetail build() {
            return new GameSessionDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionDetail> {
        public Builder gameSession(GameSession var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);
    }
}

