/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;
import software.amazon.awssdk.services.gamelift.model.FleetAttributesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFleetAttributesResponse> {
    private final List<FleetAttributes> fleetAttributes;
    private final String nextToken;

    private DescribeFleetAttributesResponse(BuilderImpl builder) {
        this.fleetAttributes = builder.fleetAttributes;
        this.nextToken = builder.nextToken;
    }

    public List<FleetAttributes> fleetAttributes() {
        return this.fleetAttributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetAttributes() == null ? 0 : this.fleetAttributes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAttributesResponse)) {
            return false;
        }
        DescribeFleetAttributesResponse other = (DescribeFleetAttributesResponse)((Object)obj);
        if (other.fleetAttributes() == null ^ this.fleetAttributes() == null) {
            return false;
        }
        if (other.fleetAttributes() != null && !other.fleetAttributes().equals(this.fleetAttributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetAttributes() != null) {
            sb.append("FleetAttributes: ").append(this.fleetAttributes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetAttributes": {
                return Optional.of(clazz.cast(this.fleetAttributes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<FleetAttributes> fleetAttributes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAttributesResponse model) {
            this.fleetAttributes(model.fleetAttributes);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetAttributes.Builder> getFleetAttributes() {
            return this.fleetAttributes != null ? (Collection)this.fleetAttributes.stream().map(FleetAttributes::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetAttributes(Collection<FleetAttributes> fleetAttributes) {
            this.fleetAttributes = FleetAttributesListCopier.copy(fleetAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAttributes(FleetAttributes ... fleetAttributes) {
            this.fleetAttributes(Arrays.asList(fleetAttributes));
            return this;
        }

        public final void setFleetAttributes(Collection<FleetAttributes.BuilderImpl> fleetAttributes) {
            this.fleetAttributes = FleetAttributesListCopier.copyFromBuilder(fleetAttributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetAttributesResponse build() {
            return new DescribeFleetAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetAttributesResponse> {
        public Builder fleetAttributes(Collection<FleetAttributes> var1);

        public Builder fleetAttributes(FleetAttributes ... var1);

        public Builder nextToken(String var1);
    }
}

