/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBuildRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateBuildRequest> {
    private final String name;
    private final String version;
    private final S3Location storageLocation;
    private final String operatingSystem;

    private CreateBuildRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.storageLocation = builder.storageLocation;
        this.operatingSystem = builder.operatingSystem;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public S3Location storageLocation() {
        return this.storageLocation;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.storageLocation() == null ? 0 : this.storageLocation().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystemString() == null ? 0 : this.operatingSystemString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBuildRequest)) {
            return false;
        }
        CreateBuildRequest other = (CreateBuildRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.storageLocation() == null ^ this.storageLocation() == null) {
            return false;
        }
        if (other.storageLocation() != null && !other.storageLocation().equals(this.storageLocation())) {
            return false;
        }
        if (other.operatingSystemString() == null ^ this.operatingSystemString() == null) {
            return false;
        }
        return other.operatingSystemString() == null || other.operatingSystemString().equals(this.operatingSystemString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.storageLocation() != null) {
            sb.append("StorageLocation: ").append(this.storageLocation()).append(",");
        }
        if (this.operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystemString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "StorageLocation": {
                return Optional.of(clazz.cast(this.storageLocation()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private S3Location storageLocation;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBuildRequest model) {
            this.name(model.name);
            this.version(model.version);
            this.storageLocation(model.storageLocation);
            this.operatingSystem(model.operatingSystem);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final S3Location.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public CreateBuildRequest build() {
            return new CreateBuildRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateBuildRequest> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder storageLocation(S3Location var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);
    }
}

