/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicy;

@SdkInternalApi
public class ScalingPolicyMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Integer> SCALINGADJUSTMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalingAdjustment").build();
    private static final MarshallingInfo<String> SCALINGADJUSTMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalingAdjustmentType").build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Threshold").build();
    private static final MarshallingInfo<Integer> EVALUATIONPERIODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationPeriods").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final ScalingPolicyMarshaller INSTANCE = new ScalingPolicyMarshaller();

    public static ScalingPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingPolicy scalingPolicy, ProtocolMarshaller protocolMarshaller) {
        if (scalingPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalingPolicy.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.scalingAdjustment(), SCALINGADJUSTMENT_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.scalingAdjustmentType(), SCALINGADJUSTMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.comparisonOperator(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.threshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.evaluationPeriods(), EVALUATIONPERIODS_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.metricName(), METRICNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

