/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.ServerProcess;
import software.amazon.awssdk.services.gamelift.model.ServerProcessListCopier;
import software.amazon.awssdk.services.gamelift.transform.RuntimeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RuntimeConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, RuntimeConfiguration> {
    private final List<ServerProcess> serverProcesses;
    private final Integer maxConcurrentGameSessionActivations;
    private final Integer gameSessionActivationTimeoutSeconds;

    private RuntimeConfiguration(BuilderImpl builder) {
        this.serverProcesses = builder.serverProcesses;
        this.maxConcurrentGameSessionActivations = builder.maxConcurrentGameSessionActivations;
        this.gameSessionActivationTimeoutSeconds = builder.gameSessionActivationTimeoutSeconds;
    }

    public List<ServerProcess> serverProcesses() {
        return this.serverProcesses;
    }

    public Integer maxConcurrentGameSessionActivations() {
        return this.maxConcurrentGameSessionActivations;
    }

    public Integer gameSessionActivationTimeoutSeconds() {
        return this.gameSessionActivationTimeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serverProcesses() == null ? 0 : this.serverProcesses().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrentGameSessionActivations() == null ? 0 : this.maxConcurrentGameSessionActivations().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionActivationTimeoutSeconds() == null ? 0 : this.gameSessionActivationTimeoutSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeConfiguration)) {
            return false;
        }
        RuntimeConfiguration other = (RuntimeConfiguration)obj;
        if (other.serverProcesses() == null ^ this.serverProcesses() == null) {
            return false;
        }
        if (other.serverProcesses() != null && !other.serverProcesses().equals(this.serverProcesses())) {
            return false;
        }
        if (other.maxConcurrentGameSessionActivations() == null ^ this.maxConcurrentGameSessionActivations() == null) {
            return false;
        }
        if (other.maxConcurrentGameSessionActivations() != null && !other.maxConcurrentGameSessionActivations().equals(this.maxConcurrentGameSessionActivations())) {
            return false;
        }
        if (other.gameSessionActivationTimeoutSeconds() == null ^ this.gameSessionActivationTimeoutSeconds() == null) {
            return false;
        }
        return other.gameSessionActivationTimeoutSeconds() == null || other.gameSessionActivationTimeoutSeconds().equals(this.gameSessionActivationTimeoutSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serverProcesses() != null) {
            sb.append("ServerProcesses: ").append(this.serverProcesses()).append(",");
        }
        if (this.maxConcurrentGameSessionActivations() != null) {
            sb.append("MaxConcurrentGameSessionActivations: ").append(this.maxConcurrentGameSessionActivations()).append(",");
        }
        if (this.gameSessionActivationTimeoutSeconds() != null) {
            sb.append("GameSessionActivationTimeoutSeconds: ").append(this.gameSessionActivationTimeoutSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuntimeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ServerProcess> serverProcesses;
        private Integer maxConcurrentGameSessionActivations;
        private Integer gameSessionActivationTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeConfiguration model) {
            this.setServerProcesses(model.serverProcesses);
            this.setMaxConcurrentGameSessionActivations(model.maxConcurrentGameSessionActivations);
            this.setGameSessionActivationTimeoutSeconds(model.gameSessionActivationTimeoutSeconds);
        }

        public final Collection<ServerProcess> getServerProcesses() {
            return this.serverProcesses;
        }

        @Override
        public final Builder serverProcesses(Collection<ServerProcess> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copy(serverProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverProcesses(ServerProcess ... serverProcesses) {
            this.serverProcesses(Arrays.asList(serverProcesses));
            return this;
        }

        public final void setServerProcesses(Collection<ServerProcess> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copy(serverProcesses);
        }

        @SafeVarargs
        public final void setServerProcesses(ServerProcess ... serverProcesses) {
            this.serverProcesses(Arrays.asList(serverProcesses));
        }

        public final Integer getMaxConcurrentGameSessionActivations() {
            return this.maxConcurrentGameSessionActivations;
        }

        @Override
        public final Builder maxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
            return this;
        }

        public final void setMaxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
        }

        public final Integer getGameSessionActivationTimeoutSeconds() {
            return this.gameSessionActivationTimeoutSeconds;
        }

        @Override
        public final Builder gameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
            return this;
        }

        public final void setGameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
        }

        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RuntimeConfiguration> {
        public Builder serverProcesses(Collection<ServerProcess> var1);

        public Builder serverProcesses(ServerProcess ... var1);

        public Builder maxConcurrentGameSessionActivations(Integer var1);

        public Builder gameSessionActivationTimeoutSeconds(Integer var1);
    }
}

