/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EventCode;
import software.amazon.awssdk.services.gamelift.transform.EventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final String eventId;
    private final String resourceId;
    private final String eventCode;
    private final String message;
    private final Instant eventTime;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.resourceId = builder.resourceId;
        this.eventCode = builder.eventCode;
        this.message = builder.message;
        this.eventTime = builder.eventTime;
    }

    public String eventId() {
        return this.eventId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String eventCode() {
        return this.eventCode;
    }

    public String message() {
        return this.message;
    }

    public Instant eventTime() {
        return this.eventTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventId() == null ? 0 : this.eventId().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.eventCode() == null ? 0 : this.eventCode().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.eventTime() == null ? 0 : this.eventTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.eventCode() == null ^ this.eventCode() == null) {
            return false;
        }
        if (other.eventCode() != null && !other.eventCode().equals(this.eventCode())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.eventTime() == null ^ this.eventTime() == null) {
            return false;
        }
        return other.eventTime() == null || other.eventTime().equals(this.eventTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.eventCode() != null) {
            sb.append("EventCode: ").append(this.eventCode()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.eventTime() != null) {
            sb.append("EventTime: ").append(this.eventTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String resourceId;
        private String eventCode;
        private String message;
        private Instant eventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.setEventId(model.eventId);
            this.setResourceId(model.resourceId);
            this.setEventCode(model.eventCode);
            this.setMessage(model.message);
            this.setEventTime(model.eventTime);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getEventCode() {
            return this.eventCode;
        }

        @Override
        public final Builder eventCode(String eventCode) {
            this.eventCode = eventCode;
            return this;
        }

        @Override
        public final Builder eventCode(EventCode eventCode) {
            this.eventCode(eventCode.toString());
            return this;
        }

        public final void setEventCode(String eventCode) {
            this.eventCode = eventCode;
        }

        public final void setEventCode(EventCode eventCode) {
            this.eventCode(eventCode.toString());
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder resourceId(String var1);

        public Builder eventCode(String var1);

        public Builder eventCode(EventCode var1);

        public Builder message(String var1);

        public Builder eventTime(Instant var1);
    }
}

