/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePlayerSessionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePlayerSessionsRequest> {
    private final String gameSessionId;
    private final String playerId;
    private final String playerSessionId;
    private final String playerSessionStatusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribePlayerSessionsRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
        this.playerSessionStatusFilter = builder.playerSessionStatusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public String playerSessionStatusFilter() {
        return this.playerSessionStatusFilter;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.playerId() == null ? 0 : this.playerId().hashCode());
        hashCode = 31 * hashCode + (this.playerSessionId() == null ? 0 : this.playerSessionId().hashCode());
        hashCode = 31 * hashCode + (this.playerSessionStatusFilter() == null ? 0 : this.playerSessionStatusFilter().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsRequest)) {
            return false;
        }
        DescribePlayerSessionsRequest other = (DescribePlayerSessionsRequest)((Object)obj);
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.playerId() == null ^ this.playerId() == null) {
            return false;
        }
        if (other.playerId() != null && !other.playerId().equals(this.playerId())) {
            return false;
        }
        if (other.playerSessionId() == null ^ this.playerSessionId() == null) {
            return false;
        }
        if (other.playerSessionId() != null && !other.playerSessionId().equals(this.playerSessionId())) {
            return false;
        }
        if (other.playerSessionStatusFilter() == null ^ this.playerSessionStatusFilter() == null) {
            return false;
        }
        if (other.playerSessionStatusFilter() != null && !other.playerSessionStatusFilter().equals(this.playerSessionStatusFilter())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.playerSessionId() != null) {
            sb.append("PlayerSessionId: ").append(this.playerSessionId()).append(",");
        }
        if (this.playerSessionStatusFilter() != null) {
            sb.append("PlayerSessionStatusFilter: ").append(this.playerSessionStatusFilter()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerSessionId;
        private String playerSessionStatusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsRequest model) {
            this.setGameSessionId(model.gameSessionId);
            this.setPlayerId(model.playerId);
            this.setPlayerSessionId(model.playerSessionId);
            this.setPlayerSessionStatusFilter(model.playerSessionStatusFilter);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public final String getPlayerSessionStatusFilter() {
            return this.playerSessionStatusFilter;
        }

        @Override
        public final Builder playerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
            return this;
        }

        public final void setPlayerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribePlayerSessionsRequest build() {
            return new DescribePlayerSessionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);

        public Builder playerSessionStatusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

