/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.Event;
import software.amazon.awssdk.services.gamelift.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFleetEventsResponse> {
    private final List<Event> events;
    private final String nextToken;

    private DescribeFleetEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    public List<Event> events() {
        return this.events;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetEventsResponse)) {
            return false;
        }
        DescribeFleetEventsResponse other = (DescribeFleetEventsResponse)((Object)obj);
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Event> events;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetEventsResponse model) {
            this.setEvents(model.events);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Event> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(Event ... events) {
            this.events(Arrays.asList(events));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetEventsResponse build() {
            return new DescribeFleetEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetEventsResponse> {
        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder nextToken(String var1);
    }
}

