/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBuildRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateBuildRequest> {
    private final String name;
    private final String version;
    private final S3Location storageLocation;
    private final String operatingSystem;

    private CreateBuildRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.storageLocation = builder.storageLocation;
        this.operatingSystem = builder.operatingSystem;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public S3Location storageLocation() {
        return this.storageLocation;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.storageLocation() == null ? 0 : this.storageLocation().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystem() == null ? 0 : this.operatingSystem().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBuildRequest)) {
            return false;
        }
        CreateBuildRequest other = (CreateBuildRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.storageLocation() == null ^ this.storageLocation() == null) {
            return false;
        }
        if (other.storageLocation() != null && !other.storageLocation().equals(this.storageLocation())) {
            return false;
        }
        if (other.operatingSystem() == null ^ this.operatingSystem() == null) {
            return false;
        }
        return other.operatingSystem() == null || other.operatingSystem().equals(this.operatingSystem());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.storageLocation() != null) {
            sb.append("StorageLocation: ").append(this.storageLocation()).append(",");
        }
        if (this.operatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystem()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private S3Location storageLocation;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBuildRequest model) {
            this.setName(model.name);
            this.setVersion(model.version);
            this.setStorageLocation(model.storageLocation);
            this.setOperatingSystem(model.operatingSystem);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final S3Location getStorageLocation() {
            return this.storageLocation;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final void setOperatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
        }

        public CreateBuildRequest build() {
            return new CreateBuildRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateBuildRequest> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder storageLocation(S3Location var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);
    }
}

