/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.gamelift.model.TargetConfiguration;

public class TargetConfigurationUnmarshaller
implements Unmarshaller<TargetConfiguration, JsonUnmarshallerContext> {
    private static final TargetConfigurationUnmarshaller INSTANCE = new TargetConfigurationUnmarshaller();

    public TargetConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        TargetConfiguration.Builder targetConfigurationBuilder = TargetConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TargetValue", targetDepth)) {
                    context.nextToken();
                    targetConfigurationBuilder.targetValue((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TargetConfiguration)targetConfigurationBuilder.build();
    }

    public static TargetConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

