/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartMatchBackfillRequestModelMarshaller {
    private static final MarshallingInfo<String> TICKETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TicketId").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationName").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionArn").isBinary(false).build();
    private static final MarshallingInfo<List> PLAYERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Players").isBinary(false).build();
    private static final StartMatchBackfillRequestModelMarshaller INSTANCE = new StartMatchBackfillRequestModelMarshaller();

    private StartMatchBackfillRequestModelMarshaller() {
    }

    public static StartMatchBackfillRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartMatchBackfillRequest startMatchBackfillRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startMatchBackfillRequest), (String)"startMatchBackfillRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startMatchBackfillRequest.ticketId(), TICKETID_BINDING);
            protocolMarshaller.marshall((Object)startMatchBackfillRequest.configurationName(), CONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)startMatchBackfillRequest.gameSessionArn(), GAMESESSIONARN_BINDING);
            protocolMarshaller.marshall(startMatchBackfillRequest.players(), PLAYERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

