/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PlayerLatencyPolicyMarshaller {
    private static final MarshallingInfo<Integer> MAXIMUMINDIVIDUALPLAYERLATENCYMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumIndividualPlayerLatencyMilliseconds").isBinary(false).build();
    private static final MarshallingInfo<Integer> POLICYDURATIONSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyDurationSeconds").isBinary(false).build();
    private static final PlayerLatencyPolicyMarshaller INSTANCE = new PlayerLatencyPolicyMarshaller();

    private PlayerLatencyPolicyMarshaller() {
    }

    public static PlayerLatencyPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlayerLatencyPolicy playerLatencyPolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)playerLatencyPolicy, (String)"playerLatencyPolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)playerLatencyPolicy.maximumIndividualPlayerLatencyMilliseconds(), MAXIMUMINDIVIDUALPLAYERLATENCYMILLISECONDS_BINDING);
            protocolMarshaller.marshall((Object)playerLatencyPolicy.policyDurationSeconds(), POLICYDURATIONSECONDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

