/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.GameSessionPlacement;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GameSessionPlacementMarshaller {
    private static final MarshallingInfo<String> PLACEMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlacementId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONQUEUENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionQueueName").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<List> GAMEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameProperties").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUMPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumPlayerSessionCount").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionName").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionArn").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionRegion").isBinary(false).build();
    private static final MarshallingInfo<List> PLAYERLATENCIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerLatencies").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<List> PLACEDPLAYERSESSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlacedPlayerSessions").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionData").isBinary(false).build();
    private static final MarshallingInfo<String> MATCHMAKERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchmakerData").isBinary(false).build();
    private static final GameSessionPlacementMarshaller INSTANCE = new GameSessionPlacementMarshaller();

    private GameSessionPlacementMarshaller() {
    }

    public static GameSessionPlacementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GameSessionPlacement gameSessionPlacement, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gameSessionPlacement, (String)"gameSessionPlacement");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gameSessionPlacement.placementId(), PLACEMENTID_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionQueueName(), GAMESESSIONQUEUENAME_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(gameSessionPlacement.gameProperties(), GAMEPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.maximumPlayerSessionCount(), MAXIMUMPLAYERSESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionName(), GAMESESSIONNAME_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionId(), GAMESESSIONID_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionArn(), GAMESESSIONARN_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionRegion(), GAMESESSIONREGION_BINDING);
            protocolMarshaller.marshall(gameSessionPlacement.playerLatencies(), PLAYERLATENCIES_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.port(), PORT_BINDING);
            protocolMarshaller.marshall(gameSessionPlacement.placedPlayerSessions(), PLACEDPLAYERSESSIONS_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.gameSessionData(), GAMESESSIONDATA_BINDING);
            protocolMarshaller.marshall((Object)gameSessionPlacement.matchmakerData(), MATCHMAKERDATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

