/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GameSessionConnectionInfoMarshaller {
    private static final MarshallingInfo<String> GAMESESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionArn").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<List> MATCHEDPLAYERSESSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchedPlayerSessions").isBinary(false).build();
    private static final GameSessionConnectionInfoMarshaller INSTANCE = new GameSessionConnectionInfoMarshaller();

    private GameSessionConnectionInfoMarshaller() {
    }

    public static GameSessionConnectionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GameSessionConnectionInfo gameSessionConnectionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gameSessionConnectionInfo, (String)"gameSessionConnectionInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gameSessionConnectionInfo.gameSessionArn(), GAMESESSIONARN_BINDING);
            protocolMarshaller.marshall((Object)gameSessionConnectionInfo.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)gameSessionConnectionInfo.port(), PORT_BINDING);
            protocolMarshaller.marshall(gameSessionConnectionInfo.matchedPlayerSessions(), MATCHEDPLAYERSESSIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

