/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopFleetActionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StopFleetActionsRequest> {
    private final String fleetId;
    private final List<String> actions;

    private StopFleetActionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.actions = builder.actions;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public List<FleetAction> actions() {
        return TypeConverter.convert(this.actions, FleetAction::fromValue);
    }

    public List<String> actionsAsStrings() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopFleetActionsRequest)) {
            return false;
        }
        StopFleetActionsRequest other = (StopFleetActionsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"StopFleetActionsRequest").add("FleetId", (Object)this.fleetId()).add("Actions", this.actionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopFleetActionsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.actionsWithStrings(model.actions);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<String> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actionsWithStrings(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsWithStrings(String ... actions) {
            this.actionsWithStrings(Arrays.asList(actions));
            return this;
        }

        @Override
        public final Builder actions(Collection<FleetAction> actions) {
            this.actions = FleetActionListCopier.copyEnumToString(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(FleetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopFleetActionsRequest build() {
            return new StopFleetActionsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, StopFleetActionsRequest> {
        public Builder fleetId(String var1);

        public Builder actionsWithStrings(Collection<String> var1);

        public Builder actionsWithStrings(String ... var1);

        public Builder actions(Collection<FleetAction> var1);

        public Builder actions(FleetAction ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

