/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.PlayerLatencyPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlayerLatencyPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, PlayerLatencyPolicy> {
    private final Integer maximumIndividualPlayerLatencyMilliseconds;
    private final Integer policyDurationSeconds;

    private PlayerLatencyPolicy(BuilderImpl builder) {
        this.maximumIndividualPlayerLatencyMilliseconds = builder.maximumIndividualPlayerLatencyMilliseconds;
        this.policyDurationSeconds = builder.policyDurationSeconds;
    }

    public Integer maximumIndividualPlayerLatencyMilliseconds() {
        return this.maximumIndividualPlayerLatencyMilliseconds;
    }

    public Integer policyDurationSeconds() {
        return this.policyDurationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumIndividualPlayerLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDurationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatencyPolicy)) {
            return false;
        }
        PlayerLatencyPolicy other = (PlayerLatencyPolicy)obj;
        return Objects.equals(this.maximumIndividualPlayerLatencyMilliseconds(), other.maximumIndividualPlayerLatencyMilliseconds()) && Objects.equals(this.policyDurationSeconds(), other.policyDurationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"PlayerLatencyPolicy").add("MaximumIndividualPlayerLatencyMilliseconds", (Object)this.maximumIndividualPlayerLatencyMilliseconds()).add("PolicyDurationSeconds", (Object)this.policyDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumIndividualPlayerLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.maximumIndividualPlayerLatencyMilliseconds()));
            }
            case "PolicyDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.policyDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerLatencyPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumIndividualPlayerLatencyMilliseconds;
        private Integer policyDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatencyPolicy model) {
            this.maximumIndividualPlayerLatencyMilliseconds(model.maximumIndividualPlayerLatencyMilliseconds);
            this.policyDurationSeconds(model.policyDurationSeconds);
        }

        public final Integer getMaximumIndividualPlayerLatencyMilliseconds() {
            return this.maximumIndividualPlayerLatencyMilliseconds;
        }

        @Override
        public final Builder maximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
            return this;
        }

        public final void setMaximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
        }

        public final Integer getPolicyDurationSeconds() {
            return this.policyDurationSeconds;
        }

        @Override
        public final Builder policyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
            return this;
        }

        public final void setPolicyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
        }

        public PlayerLatencyPolicy build() {
            return new PlayerLatencyPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlayerLatencyPolicy> {
        public Builder maximumIndividualPlayerLatencyMilliseconds(Integer var1);

        public Builder policyDurationSeconds(Integer var1);
    }
}

