/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.DesiredPlayerSessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DesiredPlayerSession
implements StructuredPojo,
ToCopyableBuilder<Builder, DesiredPlayerSession> {
    private final String playerId;
    private final String playerData;

    private DesiredPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredPlayerSession)) {
            return false;
        }
        DesiredPlayerSession other = (DesiredPlayerSession)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerData(), other.playerData());
    }

    public String toString() {
        return ToString.builder((String)"DesiredPlayerSession").add("PlayerId", (Object)this.playerId()).add("PlayerData", (Object)this.playerData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerData": {
                return Optional.ofNullable(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DesiredPlayerSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredPlayerSession model) {
            this.playerId(model.playerId);
            this.playerData(model.playerData);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public DesiredPlayerSession build() {
            return new DesiredPlayerSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DesiredPlayerSession> {
        public Builder playerId(String var1);

        public Builder playerData(String var1);
    }
}

