/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.gamelift.model.Build;
import software.amazon.awssdk.services.gamelift.model.Credentials;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBuildResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, CreateBuildResponse> {
    private final Build build;
    private final Credentials uploadCredentials;
    private final S3Location storageLocation;

    private CreateBuildResponse(BuilderImpl builder) {
        super(builder);
        this.build = builder.build;
        this.uploadCredentials = builder.uploadCredentials;
        this.storageLocation = builder.storageLocation;
    }

    public Build build() {
        return this.build;
    }

    public Credentials uploadCredentials() {
        return this.uploadCredentials;
    }

    public S3Location storageLocation() {
        return this.storageLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.build());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBuildResponse)) {
            return false;
        }
        CreateBuildResponse other = (CreateBuildResponse)((Object)obj);
        return Objects.equals(this.build(), other.build()) && Objects.equals(this.uploadCredentials(), other.uploadCredentials()) && Objects.equals(this.storageLocation(), other.storageLocation());
    }

    public String toString() {
        return ToString.builder((String)"CreateBuildResponse").add("Build", (Object)this.build()).add("UploadCredentials", (Object)this.uploadCredentials()).add("StorageLocation", (Object)this.storageLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Build": {
                return Optional.ofNullable(clazz.cast(this.build()));
            }
            case "UploadCredentials": {
                return Optional.ofNullable(clazz.cast(this.uploadCredentials()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private Build build;
        private Credentials uploadCredentials;
        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBuildResponse model) {
            super(model);
            this.build(model.build);
            this.uploadCredentials(model.uploadCredentials);
            this.storageLocation(model.storageLocation);
        }

        public final Build.Builder getBuild() {
            return this.build != null ? this.build.toBuilder() : null;
        }

        @Override
        public final Builder build(Build build) {
            this.build = build;
            return this;
        }

        public final void setBuild(Build.BuilderImpl build) {
            this.build = build != null ? build.build() : null;
        }

        public final Credentials.Builder getUploadCredentials() {
            return this.uploadCredentials != null ? this.uploadCredentials.toBuilder() : null;
        }

        @Override
        public final Builder uploadCredentials(Credentials uploadCredentials) {
            this.uploadCredentials = uploadCredentials;
            return this;
        }

        public final void setUploadCredentials(Credentials.BuilderImpl uploadCredentials) {
            this.uploadCredentials = uploadCredentials != null ? uploadCredentials.build() : null;
        }

        public final S3Location.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public CreateBuildResponse build() {
            return new CreateBuildResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, CreateBuildResponse> {
        public Builder build(Build var1);

        default public Builder build(Consumer<Build.Builder> build) {
            return this.build((Build)((Build.Builder)Build.builder().applyMutation(build)).build());
        }

        public Builder uploadCredentials(Credentials var1);

        default public Builder uploadCredentials(Consumer<Credentials.Builder> uploadCredentials) {
            return this.uploadCredentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(uploadCredentials)).build());
        }

        public Builder storageLocation(S3Location var1);

        default public Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return this.storageLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(storageLocation)).build());
        }
    }
}

